/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractSimpleAggregationFunction;
import com.facebook.presto.operator.aggregation.state.InitialLongValue;
import com.facebook.presto.operator.aggregation.state.NullableLongState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;

public class LongMinAggregation
extends AbstractSimpleAggregationFunction<LongMinState> {
    public static final LongMinAggregation LONG_MIN = new LongMinAggregation();

    public LongMinAggregation() {
        super((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
    }

    @Override
    public void processInput(LongMinState state, Block block, int index) {
        state.setNull(false);
        state.setLong(Math.min(state.getLong(), block.getLong(index)));
    }

    public static interface LongMinState
    extends NullableLongState {
        @Override
        @InitialLongValue(value=0x7FFFFFFFFFFFFFFFL)
        public long getLong();
    }
}

