/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractSimpleAggregationFunction;
import com.facebook.presto.operator.aggregation.state.InitialLongValue;
import com.facebook.presto.operator.aggregation.state.NullableLongState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;

public class LongMaxAggregation
extends AbstractSimpleAggregationFunction<LongMaxState> {
    public static final LongMaxAggregation LONG_MAX = new LongMaxAggregation();

    public LongMaxAggregation() {
        super((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
    }

    @Override
    public void processInput(LongMaxState state, Block block, int index) {
        state.setNull(false);
        state.setLong(Math.max(state.getLong(), block.getLong(index)));
    }

    public static interface LongMaxState
    extends NullableLongState {
        @Override
        @InitialLongValue(value=-9223372036854775808L)
        public long getLong();
    }
}

