/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractSimpleAggregationFunction;
import com.facebook.presto.operator.aggregation.state.InitialDoubleValue;
import com.facebook.presto.operator.aggregation.state.NullableDoubleState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;

public class DoubleMaxAggregation
extends AbstractSimpleAggregationFunction<DoubleMaxState> {
    public static final DoubleMaxAggregation DOUBLE_MAX = new DoubleMaxAggregation();

    public DoubleMaxAggregation() {
        super((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE);
    }

    @Override
    public void processInput(DoubleMaxState state, Block block, int index) {
        state.setNull(false);
        state.setDouble(Math.max(state.getDouble(), block.getDouble(index)));
    }

    public static interface DoubleMaxState
    extends NullableDoubleState {
        @Override
        @InitialDoubleValue(value=-Infinity)
        public double getDouble();
    }
}

