/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.array.LongBigArray;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class CountAggregation
implements AggregationFunction {
    public static final CountAggregation COUNT = new CountAggregation();

    @Override
    public List<Type> getParameterTypes() {
        return ImmutableList.of();
    }

    @Override
    public Type getFinalType() {
        return BigintType.BIGINT;
    }

    @Override
    public Type getIntermediateType() {
        return BigintType.BIGINT;
    }

    @Override
    public boolean isDecomposable() {
        return true;
    }

    @Override
    public CountGroupedAccumulator createGroupedAggregation(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int[] argumentChannels) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"count does not support approximate queries");
        return new CountGroupedAccumulator(maskChannel, sampleWeightChannel);
    }

    @Override
    public GroupedAccumulator createGroupedIntermediateAggregation(double confidence) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"count does not support approximate queries");
        return new CountGroupedAccumulator((Optional<Integer>)Optional.absent(), (Optional<Integer>)Optional.absent());
    }

    @Override
    public CountAccumulator createAggregation(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int ... argumentChannels) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"count does not support approximate queries");
        return new CountAccumulator(maskChannel, sampleWeightChannel);
    }

    @Override
    public CountAccumulator createIntermediateAggregation(double confidence) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"count does not support approximate queries");
        return new CountAccumulator((Optional<Integer>)Optional.absent(), (Optional<Integer>)Optional.absent());
    }

    public static class CountAccumulator
    implements Accumulator {
        private long count;
        private final Optional<Integer> maskChannel;
        private final Optional<Integer> sampleWeightChannel;

        public CountAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel) {
            this.maskChannel = maskChannel;
            this.sampleWeightChannel = sampleWeightChannel;
        }

        @Override
        public long getEstimatedSize() {
            return 0L;
        }

        @Override
        public Type getFinalType() {
            return BigintType.BIGINT;
        }

        @Override
        public Type getIntermediateType() {
            return BigintType.BIGINT;
        }

        @Override
        public void addInput(Page page) {
            if (!this.maskChannel.isPresent() && !this.sampleWeightChannel.isPresent()) {
                this.count += (long)page.getPositionCount();
            } else {
                BlockCursor masks = null;
                if (this.maskChannel.isPresent()) {
                    masks = page.getBlock((Integer)this.maskChannel.get()).cursor();
                }
                BlockCursor sampleWeights = null;
                if (this.sampleWeightChannel.isPresent()) {
                    sampleWeights = page.getBlock((Integer)this.sampleWeightChannel.get()).cursor();
                }
                for (int i = 0; i < page.getPositionCount(); ++i) {
                    Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0);
                    Preconditions.checkState((sampleWeights == null || sampleWeights.advanceNextPosition() ? 1 : 0) != 0);
                    this.count += SimpleAggregationFunction.computeSampleWeight(masks, sampleWeights);
                }
            }
        }

        @Override
        public void addIntermediate(Block block) {
            BlockCursor intermediates = block.cursor();
            for (int position = 0; position < block.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)intermediates.advanceNextPosition());
                this.count += intermediates.getLong();
            }
        }

        @Override
        public final Block evaluateIntermediate() {
            return this.evaluateFinal();
        }

        @Override
        public final Block evaluateFinal() {
            BlockBuilder out = this.getFinalType().createBlockBuilder(new BlockBuilderStatus());
            out.appendLong(this.count);
            return out.build();
        }
    }

    public static class CountGroupedAccumulator
    implements GroupedAccumulator {
        private final LongBigArray counts = new LongBigArray();
        private final Optional<Integer> maskChannel;
        private final Optional<Integer> sampleWeightChannel;

        public CountGroupedAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel) {
            this.maskChannel = maskChannel;
            this.sampleWeightChannel = sampleWeightChannel;
        }

        @Override
        public long getEstimatedSize() {
            return this.counts.sizeOf();
        }

        @Override
        public Type getFinalType() {
            return BigintType.BIGINT;
        }

        @Override
        public Type getIntermediateType() {
            return BigintType.BIGINT;
        }

        @Override
        public void addInput(GroupByIdBlock groupIdsBlock, Page page) {
            this.counts.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor masks = this.maskChannel.isPresent() ? page.getBlock((Integer)this.maskChannel.get()).cursor() : null;
            BlockCursor sampleWeights = this.sampleWeightChannel.isPresent() ? page.getBlock((Integer)this.sampleWeightChannel.get()).cursor() : null;
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                long groupId = groupIdsBlock.getGroupId(position);
                Preconditions.checkState((masks == null || masks.advanceNextPosition() ? 1 : 0) != 0);
                Preconditions.checkState((sampleWeights == null || sampleWeights.advanceNextPosition() ? 1 : 0) != 0);
                this.counts.add(groupId, SimpleAggregationFunction.computeSampleWeight(masks, sampleWeights));
            }
        }

        @Override
        public void addIntermediate(GroupByIdBlock groupIdsBlock, Block block) {
            this.counts.ensureCapacity(groupIdsBlock.getGroupCount());
            BlockCursor intermediates = block.cursor();
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                Preconditions.checkState((boolean)intermediates.advanceNextPosition());
                long groupId = groupIdsBlock.getGroupId(position);
                this.counts.add(groupId, intermediates.getLong());
            }
        }

        @Override
        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            this.evaluateFinal(groupId, output);
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            long value = this.counts.get(groupId);
            output.appendLong(value);
        }
    }
}

