/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractAggregationFunction;
import com.facebook.presto.operator.aggregation.state.LongAndDoubleState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;

public class AverageAggregation
extends AbstractAggregationFunction<LongAndDoubleState> {
    private final boolean inputIsLong;

    public AverageAggregation(Type parameterType) {
        super((Type)DoubleType.DOUBLE, (Type)VarcharType.VARCHAR, parameterType);
        if (parameterType == BigintType.BIGINT) {
            this.inputIsLong = true;
        } else if (parameterType == DoubleType.DOUBLE) {
            this.inputIsLong = false;
        } else {
            throw new IllegalArgumentException("Expected parameter type to be BIGINT or DOUBLE, but was " + parameterType);
        }
    }

    @Override
    protected void processInput(LongAndDoubleState state, Block block, int index) {
        state.setLong(state.getLong() + 1L);
        double value = this.inputIsLong ? (double)block.getLong(index) : block.getDouble(index);
        state.setDouble(state.getDouble() + value);
    }

    @Override
    protected void combineState(LongAndDoubleState state, LongAndDoubleState otherState) {
        state.setLong(state.getLong() + otherState.getLong());
        state.setDouble(state.getDouble() + otherState.getDouble());
    }

    @Override
    protected void evaluateFinal(LongAndDoubleState state, BlockBuilder out) {
        long count = state.getLong();
        if (count == 0L) {
            out.appendNull();
        } else {
            double value = state.getDouble();
            out.appendDouble(value / (double)count);
        }
    }
}

