/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractApproximateAggregationFunction;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.ApproximateUtils;
import com.facebook.presto.operator.aggregation.state.VarianceState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.Slices;

public class ApproximateLongSumAggregation
extends AbstractApproximateAggregationFunction<ApproximateLongSumState> {
    public static final ApproximateLongSumAggregation LONG_APPROXIMATE_SUM_AGGREGATION = new ApproximateLongSumAggregation();

    public ApproximateLongSumAggregation() {
        super((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
    }

    @Override
    protected void processInput(ApproximateLongSumState state, Block block, int index, long sampleWeight) {
        long value = block.getLong(index);
        state.setWeightedCount(state.getWeightedCount() + sampleWeight);
        state.setSum(state.getSum() + value * sampleWeight);
        AggregationUtils.updateVarianceState(state, value);
    }

    @Override
    protected void combineState(ApproximateLongSumState state, ApproximateLongSumState otherState) {
        state.setSum(state.getSum() + otherState.getSum());
        state.setWeightedCount(state.getWeightedCount() + otherState.getWeightedCount());
        AggregationUtils.mergeVarianceState(state, otherState);
    }

    @Override
    protected void evaluateFinal(ApproximateLongSumState state, double confidence, BlockBuilder out) {
        if (state.getWeightedCount() == 0L) {
            out.appendNull();
            return;
        }
        String result = ApproximateUtils.formatApproximateResult(state.getSum(), ApproximateUtils.sumError(state.getCount(), state.getWeightedCount(), state.getM2(), state.getMean()), confidence, true);
        out.appendSlice(Slices.utf8Slice((String)result));
    }

    public static interface ApproximateLongSumState
    extends VarianceState {
        public long getSum();

        public void setSum(long var1);

        public long getWeightedCount();

        public void setWeightedCount(long var1);
    }
}

