/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractApproximateAggregationFunction;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.ApproximateUtils;
import com.facebook.presto.operator.aggregation.state.VarianceState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.Slices;

public class ApproximateDoubleSumAggregation
extends AbstractApproximateAggregationFunction<ApproximateDoubleSumState> {
    public static final ApproximateDoubleSumAggregation DOUBLE_APPROXIMATE_SUM_AGGREGATION = new ApproximateDoubleSumAggregation();

    public ApproximateDoubleSumAggregation() {
        super((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, (Type)DoubleType.DOUBLE);
    }

    @Override
    protected void processInput(ApproximateDoubleSumState state, Block block, int index, long sampleWeight) {
        double value = block.getDouble(index);
        state.setWeightedCount(state.getWeightedCount() + sampleWeight);
        state.setSum(state.getSum() + value * (double)sampleWeight);
        AggregationUtils.updateVarianceState(state, value);
    }

    @Override
    protected void combineState(ApproximateDoubleSumState state, ApproximateDoubleSumState otherState) {
        state.setSum(state.getSum() + otherState.getSum());
        state.setWeightedCount(state.getWeightedCount() + otherState.getWeightedCount());
        AggregationUtils.mergeVarianceState(state, otherState);
    }

    @Override
    protected void evaluateFinal(ApproximateDoubleSumState state, double confidence, BlockBuilder out) {
        if (state.getWeightedCount() == 0L) {
            out.appendNull();
            return;
        }
        String result = ApproximateUtils.formatApproximateResult(state.getSum(), ApproximateUtils.sumError(state.getCount(), state.getWeightedCount(), state.getM2(), state.getMean()), confidence, false);
        out.appendSlice(Slices.utf8Slice((String)result));
    }

    public static interface ApproximateDoubleSumState
    extends VarianceState {
        public double getSum();

        public void setSum(double var1);

        public long getWeightedCount();

        public void setWeightedCount(long var1);
    }
}

