/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractApproximateAggregationFunction;
import com.facebook.presto.operator.aggregation.ApproximateUtils;
import com.facebook.presto.operator.aggregation.state.AccumulatorState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.Slices;

public class ApproximateCountColumnAggregation
extends AbstractApproximateAggregationFunction<ApproximateCountState> {
    public ApproximateCountColumnAggregation(Type parameterType) {
        super((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, parameterType);
    }

    @Override
    protected void processInput(ApproximateCountState state, Block block, int index, long sampleWeight) {
        state.setCount(state.getCount() + sampleWeight);
        state.setSamples(state.getSamples() + 1L);
    }

    @Override
    protected void combineState(ApproximateCountState state, ApproximateCountState otherState) {
        state.setCount(state.getCount() + otherState.getCount());
        state.setSamples(state.getSamples() + otherState.getSamples());
    }

    @Override
    protected void evaluateFinal(ApproximateCountState state, double confidence, BlockBuilder out) {
        String result = ApproximateUtils.formatApproximateResult(state.getCount(), ApproximateUtils.countError(state.getSamples(), state.getCount()), confidence, true);
        out.appendSlice(Slices.utf8Slice((String)result));
    }

    public static interface ApproximateCountState
    extends AccumulatorState {
        public long getCount();

        public void setCount(long var1);

        public long getSamples();

        public void setSamples(long var1);
    }
}

