/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractApproximateAggregationFunction;
import com.facebook.presto.operator.aggregation.ApproximateUtils;
import com.facebook.presto.operator.aggregation.state.AccumulatorState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.Slices;

public class ApproximateAverageAggregation
extends AbstractApproximateAggregationFunction<ApproximateAverageState> {
    private final boolean inputIsLong;

    public ApproximateAverageAggregation(Type parameterType) {
        super((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, parameterType);
        if (parameterType == BigintType.BIGINT) {
            this.inputIsLong = true;
        } else if (parameterType == DoubleType.DOUBLE) {
            this.inputIsLong = false;
        } else {
            throw new IllegalArgumentException("Expected parameter type to be BIGINT or DOUBLE, but was " + parameterType);
        }
    }

    @Override
    protected void processInput(ApproximateAverageState state, Block block, int index, long sampleWeight) {
        double inputValue = this.inputIsLong ? (double)block.getLong(index) : block.getDouble(index);
        long currentCount = state.getCount();
        double currentMean = state.getMean();
        int i = 0;
        while ((long)i < sampleWeight) {
            double delta = inputValue - currentMean;
            state.setM2(state.getM2() + delta * (inputValue - (currentMean += delta / (double)(++currentCount))));
            ++i;
        }
        state.setCount(currentCount);
        state.setMean(currentMean);
        state.setSamples(state.getSamples() + 1L);
    }

    @Override
    protected void combineState(ApproximateAverageState state, ApproximateAverageState otherState) {
        long inputCount = otherState.getCount();
        long inputSamples = otherState.getSamples();
        double inputMean = otherState.getMean();
        double inputM2 = otherState.getM2();
        long currentCount = state.getCount();
        double currentMean = state.getMean();
        double currentM2 = state.getM2();
        if (inputCount > 0L) {
            long newCount = currentCount + inputCount;
            double newMean = ((double)currentCount * currentMean + (double)inputCount * inputMean) / (double)newCount;
            double delta = inputMean - currentMean;
            double newM2 = currentM2 + inputM2 + delta * delta * (double)(currentCount * inputCount) / (double)newCount;
            state.setCount(newCount);
            state.setSamples(state.getSamples() + inputSamples);
            state.setMean(newMean);
            state.setM2(newM2);
        }
    }

    @Override
    protected void evaluateFinal(ApproximateAverageState state, double confidence, BlockBuilder out) {
        if (state.getCount() == 0L) {
            out.appendNull();
        } else {
            String result = ApproximateAverageAggregation.formatApproximateAverage(state.getSamples(), state.getMean(), state.getM2() / (double)state.getCount(), confidence);
            out.appendSlice(Slices.utf8Slice((String)result));
        }
    }

    private static String formatApproximateAverage(long samples, double mean, double variance, double confidence) {
        return ApproximateUtils.formatApproximateResult(mean, Math.sqrt(variance / (double)samples), confidence, false);
    }

    public static interface ApproximateAverageState
    extends AccumulatorState {
        public long getCount();

        public void setCount(long var1);

        public long getSamples();

        public void setSamples(long var1);

        public double getMean();

        public void setMean(double var1);

        public double getM2();

        public void setM2(double var1);
    }
}

