/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractAggregationFunction;
import com.facebook.presto.operator.aggregation.AbstractApproximateAggregationFunction;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.IsolatedClass;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.operator.aggregation.state.VarianceState;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;

public final class AggregationUtils {
    private AggregationUtils() {
    }

    public static AggregationFunction createIsolatedApproximateAggregation(Class<? extends AbstractApproximateAggregationFunction> aggregationClass, Type parameterType) {
        Class<? extends AbstractApproximateAggregationFunction> functionClass = IsolatedClass.isolateClass(AggregationFunction.class, aggregationClass, AbstractApproximateAggregationFunction.class, SimpleAggregationFunction.class, AbstractApproximateAggregationFunction.GenericGroupedAccumulator.class, SimpleAggregationFunction.SimpleGroupedAccumulator.class, AbstractApproximateAggregationFunction.GenericAccumulator.class, SimpleAggregationFunction.SimpleAccumulator.class);
        try {
            return functionClass.getConstructor(Type.class).newInstance(parameterType);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static AggregationFunction createIsolatedAggregation(Class<? extends AggregationFunction> aggregationClass, Type parameterType) {
        Class<? extends AggregationFunction> functionClass = IsolatedClass.isolateClass(AggregationFunction.class, aggregationClass, AbstractAggregationFunction.class, SimpleAggregationFunction.class, AbstractAggregationFunction.GenericGroupedAccumulator.class, SimpleAggregationFunction.SimpleGroupedAccumulator.class, AbstractAggregationFunction.GenericAccumulator.class, SimpleAggregationFunction.SimpleAccumulator.class);
        try {
            return functionClass.getConstructor(Type.class).newInstance(parameterType);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void updateVarianceState(VarianceState state, double value) {
        state.setCount(state.getCount() + 1L);
        double delta = value - state.getMean();
        state.setMean(state.getMean() + delta / (double)state.getCount());
        state.setM2(state.getM2() + delta * (value - state.getMean()));
    }

    public static void mergeVarianceState(VarianceState state, VarianceState otherState) {
        long count = otherState.getCount();
        double mean = otherState.getMean();
        double m2 = otherState.getM2();
        Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (Object)"count is negative");
        if (count == 0L) {
            return;
        }
        long newCount = count + state.getCount();
        double newMean = ((double)count * mean + (double)state.getCount() * state.getMean()) / (double)newCount;
        double delta = mean - state.getMean();
        double m2Delta = m2 + delta * delta * (double)count * (double)state.getCount() / (double)newCount;
        state.setM2(state.getM2() + m2Delta);
        state.setCount(newCount);
        state.setMean(newMean);
    }
}

