/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.ApproximateUtils;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.operator.aggregation.state.AccumulatorState;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.operator.aggregation.state.GroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.airlift.event.client.TypeParameterUtils;
import java.lang.reflect.Type;

public abstract class AbstractApproximateAggregationFunction<T extends AccumulatorState>
extends SimpleAggregationFunction {
    private final AccumulatorStateFactory<T> stateFactory;
    private final AccumulatorStateSerializer<T> stateSerializer;

    protected AbstractApproximateAggregationFunction(com.facebook.presto.spi.type.Type finalType, com.facebook.presto.spi.type.Type intermediateType, com.facebook.presto.spi.type.Type parameterType) {
        super(finalType, intermediateType, parameterType);
        Type[] types = TypeParameterUtils.getTypeParameters(AbstractApproximateAggregationFunction.class, this.getClass());
        Preconditions.checkState((types.length == 1 && types[0] instanceof Class ? 1 : 0) != 0);
        this.stateFactory = new StateCompiler().generateStateFactory((Class)types[0]);
        this.stateSerializer = new StateCompiler().generateStateSerializer((Class)types[0]);
    }

    protected abstract void processInput(T var1, Block var2, int var3, long var4);

    protected void processIntermediate(T state, T scratchState, Block block, int index) {
        this.stateSerializer.deserialize(block, index, scratchState);
        this.combineState(state, scratchState);
    }

    protected abstract void combineState(T var1, T var2);

    protected abstract void evaluateFinal(T var1, double var2, BlockBuilder var4);

    private T createSingleState() {
        return (T)((AccumulatorState)this.stateFactory.createSingleState());
    }

    private T createGroupedState() {
        return (T)((AccumulatorState)this.stateFactory.createGroupedState());
    }

    protected AccumulatorStateSerializer<T> getStateSerializer() {
        return this.stateSerializer;
    }

    @Override
    protected final GroupedAccumulator createGroupedAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        return new GenericGroupedAccumulator(valueChannel, maskChannel, sampleWeightChannel, confidence);
    }

    @Override
    protected final Accumulator createAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        return new GenericAccumulator(valueChannel, maskChannel, sampleWeightChannel, confidence);
    }

    public final class GenericAccumulator
    extends SimpleAggregationFunction.SimpleAccumulator {
        private final T state;
        private final double confidence;

        public GenericAccumulator(int valueChannel, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence) {
            super(valueChannel, AbstractApproximateAggregationFunction.this.getFinalType(), AbstractApproximateAggregationFunction.this.getIntermediateType(), maskChannel, sampleWeightChannel);
            this.state = AbstractApproximateAggregationFunction.this.createSingleState();
            this.confidence = confidence;
        }

        @Override
        protected void processInput(Block values, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            Block masks = null;
            if (maskBlock.isPresent()) {
                masks = (Block)maskBlock.get();
            }
            Block sampleWeights = null;
            if (sampleWeightBlock.isPresent()) {
                sampleWeights = (Block)sampleWeightBlock.get();
            }
            for (int position = 0; position < values.getPositionCount(); ++position) {
                long sampleWeight = ApproximateUtils.computeSampleWeight(masks, sampleWeights, position);
                if (values.isNull(position) || sampleWeight <= 0L) continue;
                AbstractApproximateAggregationFunction.this.processInput(this.state, values, position, sampleWeight);
            }
        }

        @Override
        public long getEstimatedSize() {
            return this.state.getEstimatedSize();
        }

        @Override
        protected void processIntermediate(Block block) {
            AccumulatorState scratchState = AbstractApproximateAggregationFunction.this.createSingleState();
            for (int position = 0; position < block.getPositionCount(); ++position) {
                if (block.isNull(position)) continue;
                AbstractApproximateAggregationFunction.this.processIntermediate(this.state, scratchState, block, position);
            }
        }

        @Override
        protected void evaluateIntermediate(BlockBuilder out) {
            AbstractApproximateAggregationFunction.this.getStateSerializer().serialize(this.state, out);
        }

        @Override
        public void evaluateFinal(BlockBuilder out) {
            AbstractApproximateAggregationFunction.this.evaluateFinal(this.state, this.confidence, out);
        }
    }

    public final class GenericGroupedAccumulator
    extends SimpleAggregationFunction.SimpleGroupedAccumulator {
        private final T state;
        private final GroupedAccumulatorState groupedState;
        private final double confidence;

        public GenericGroupedAccumulator(int valueChannel, Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence) {
            super(valueChannel, AbstractApproximateAggregationFunction.this.getFinalType(), AbstractApproximateAggregationFunction.this.getIntermediateType(), maskChannel, sampleWeightChannel);
            this.state = AbstractApproximateAggregationFunction.this.createGroupedState();
            Preconditions.checkArgument((boolean)(this.state instanceof GroupedAccumulatorState), (Object)"state is not a GroupedAccumulatorState");
            this.groupedState = (GroupedAccumulatorState)this.state;
            this.confidence = confidence;
        }

        @Override
        public long getEstimatedSize() {
            return this.state.getEstimatedSize();
        }

        @Override
        protected void processInput(GroupByIdBlock groupIdsBlock, Block values, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            this.groupedState.ensureCapacity(groupIdsBlock.getGroupCount());
            Block masks = null;
            if (maskBlock.isPresent()) {
                masks = (Block)maskBlock.get();
            }
            Block sampleWeights = null;
            if (sampleWeightBlock.isPresent()) {
                sampleWeights = (Block)sampleWeightBlock.get();
            }
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                long sampleWeight = ApproximateUtils.computeSampleWeight(masks, sampleWeights, position);
                if (values.isNull(position) || sampleWeight <= 0L) continue;
                this.groupedState.setGroupId(groupIdsBlock.getGroupId(position));
                AbstractApproximateAggregationFunction.this.processInput(this.state, values, position, sampleWeight);
            }
        }

        @Override
        protected void processIntermediate(GroupByIdBlock groupIdsBlock, Block intermediates) {
            this.groupedState.ensureCapacity(groupIdsBlock.getGroupCount());
            AccumulatorState scratchState = AbstractApproximateAggregationFunction.this.createSingleState();
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                if (intermediates.isNull(position)) continue;
                this.groupedState.setGroupId(groupIdsBlock.getGroupId(position));
                AbstractApproximateAggregationFunction.this.processIntermediate(this.state, scratchState, intermediates, position);
            }
        }

        @Override
        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            this.groupedState.setGroupId(groupId);
            AbstractApproximateAggregationFunction.this.getStateSerializer().serialize(this.state, output);
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            this.groupedState.setGroupId(groupId);
            AbstractApproximateAggregationFunction.this.evaluateFinal(this.state, this.confidence, output);
        }
    }
}

