/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.SimpleAggregationFunction;
import com.facebook.presto.operator.aggregation.state.AccumulatorState;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.operator.aggregation.state.GroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.airlift.event.client.TypeParameterUtils;
import java.lang.reflect.Type;

public abstract class AbstractAggregationFunction<T extends AccumulatorState>
extends SimpleAggregationFunction {
    private final AccumulatorStateFactory<T> stateFactory;
    private final AccumulatorStateSerializer<T> stateSerializer;

    protected AbstractAggregationFunction(com.facebook.presto.spi.type.Type finalType, com.facebook.presto.spi.type.Type intermediateType, com.facebook.presto.spi.type.Type parameterType) {
        super(finalType, intermediateType, parameterType);
        Type[] types = TypeParameterUtils.getTypeParameters(AbstractAggregationFunction.class, this.getClass());
        Preconditions.checkState((types.length == 1 && types[0] instanceof Class ? 1 : 0) != 0);
        this.stateFactory = new StateCompiler().generateStateFactory((Class)types[0]);
        this.stateSerializer = new StateCompiler().generateStateSerializer((Class)types[0]);
    }

    protected abstract void processInput(T var1, Block var2, int var3);

    protected void processIntermediate(T state, T scratchState, Block block, int index) {
        this.stateSerializer.deserialize(block, index, scratchState);
        this.combineState(state, scratchState);
    }

    protected abstract void combineState(T var1, T var2);

    protected void evaluateFinal(T state, BlockBuilder out) {
        Preconditions.checkState((this.getFinalType() == BigintType.BIGINT || this.getFinalType() == DoubleType.DOUBLE || this.getFinalType() == BooleanType.BOOLEAN || this.getFinalType() == VarcharType.VARCHAR ? 1 : 0) != 0);
        this.getStateSerializer().serialize(state, out);
    }

    private T createSingleState() {
        return (T)((AccumulatorState)this.stateFactory.createSingleState());
    }

    private T createGroupedState() {
        return (T)((AccumulatorState)this.stateFactory.createGroupedState());
    }

    protected AccumulatorStateSerializer<T> getStateSerializer() {
        return this.stateSerializer;
    }

    @Override
    protected final GroupedAccumulator createGroupedAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"Approximate queries not supported");
        Preconditions.checkArgument((!sampleWeightChannel.isPresent() ? 1 : 0) != 0, (Object)"Sampled data not supported");
        return new GenericGroupedAccumulator(valueChannel, maskChannel);
    }

    @Override
    protected final Accumulator createAccumulator(Optional<Integer> maskChannel, Optional<Integer> sampleWeightChannel, double confidence, int valueChannel) {
        Preconditions.checkArgument((confidence == 1.0 ? 1 : 0) != 0, (Object)"Approximate queries not supported");
        Preconditions.checkArgument((!sampleWeightChannel.isPresent() ? 1 : 0) != 0, (Object)"Sampled data not supported");
        return new GenericAccumulator(valueChannel, maskChannel);
    }

    public final class GenericAccumulator
    extends SimpleAggregationFunction.SimpleAccumulator {
        private final T state;

        public GenericAccumulator(int valueChannel, Optional<Integer> maskChannel) {
            super(valueChannel, AbstractAggregationFunction.this.getFinalType(), AbstractAggregationFunction.this.getIntermediateType(), maskChannel, (Optional<Integer>)Optional.absent());
            this.state = AbstractAggregationFunction.this.createSingleState();
        }

        @Override
        protected void processInput(Block values, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            Preconditions.checkArgument((!sampleWeightBlock.isPresent() ? 1 : 0) != 0, (Object)"Sampled data not supported");
            Block masks = null;
            if (maskBlock.isPresent()) {
                masks = (Block)maskBlock.get();
            }
            for (int position = 0; position < values.getPositionCount(); ++position) {
                if (masks != null && !masks.getBoolean(position) || values.isNull(position)) continue;
                AbstractAggregationFunction.this.processInput(this.state, values, position);
            }
        }

        @Override
        public long getEstimatedSize() {
            return this.state.getEstimatedSize();
        }

        @Override
        protected void processIntermediate(Block block) {
            AccumulatorState scratchState = AbstractAggregationFunction.this.createSingleState();
            for (int position = 0; position < block.getPositionCount(); ++position) {
                if (block.isNull(position)) continue;
                AbstractAggregationFunction.this.processIntermediate(this.state, scratchState, block, position);
            }
        }

        @Override
        protected void evaluateIntermediate(BlockBuilder out) {
            AbstractAggregationFunction.this.getStateSerializer().serialize(this.state, out);
        }

        @Override
        public void evaluateFinal(BlockBuilder out) {
            AbstractAggregationFunction.this.evaluateFinal(this.state, out);
        }
    }

    public final class GenericGroupedAccumulator
    extends SimpleAggregationFunction.SimpleGroupedAccumulator {
        private final T state;
        private final GroupedAccumulatorState groupedState;

        public GenericGroupedAccumulator(int valueChannel, Optional<Integer> maskChannel) {
            super(valueChannel, AbstractAggregationFunction.this.getFinalType(), AbstractAggregationFunction.this.getIntermediateType(), maskChannel, (Optional<Integer>)Optional.absent());
            this.state = AbstractAggregationFunction.this.createGroupedState();
            Preconditions.checkArgument((boolean)(this.state instanceof GroupedAccumulatorState), (Object)"state is not a GroupedAccumulatorState");
            this.groupedState = (GroupedAccumulatorState)this.state;
        }

        @Override
        public long getEstimatedSize() {
            return this.state.getEstimatedSize();
        }

        @Override
        protected void processInput(GroupByIdBlock groupIdsBlock, Block values, Optional<Block> maskBlock, Optional<Block> sampleWeightBlock) {
            Preconditions.checkArgument((!sampleWeightBlock.isPresent() ? 1 : 0) != 0, (Object)"Sampled data not supported");
            this.groupedState.ensureCapacity(groupIdsBlock.getGroupCount());
            Block masks = null;
            if (maskBlock.isPresent()) {
                masks = (Block)maskBlock.get();
            }
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                if (masks != null && !masks.getBoolean(position) || values.isNull(position)) continue;
                this.groupedState.setGroupId(groupIdsBlock.getGroupId(position));
                AbstractAggregationFunction.this.processInput(this.state, values, position);
            }
        }

        @Override
        protected void processIntermediate(GroupByIdBlock groupIdsBlock, Block intermediates) {
            this.groupedState.ensureCapacity(groupIdsBlock.getGroupCount());
            AccumulatorState scratchState = AbstractAggregationFunction.this.createSingleState();
            for (int position = 0; position < groupIdsBlock.getPositionCount(); ++position) {
                if (intermediates.isNull(position)) continue;
                this.groupedState.setGroupId(groupIdsBlock.getGroupId(position));
                AbstractAggregationFunction.this.processIntermediate(this.state, scratchState, intermediates, position);
            }
        }

        @Override
        public void evaluateIntermediate(int groupId, BlockBuilder output) {
            this.groupedState.setGroupId(groupId);
            AbstractAggregationFunction.this.getStateSerializer().serialize(this.state, output);
        }

        @Override
        public void evaluateFinal(int groupId, BlockBuilder output) {
            this.groupedState.setGroupId(groupId);
            AbstractAggregationFunction.this.evaluateFinal(this.state, output);
        }
    }
}

