/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockCursor;
import java.util.List;

public class TwoChannelPagesHashStrategy
implements PagesHashStrategy {
    private final List<Block> channelA;
    private final List<Block> channelB;
    private final List<Block> hashChannelA;
    private final List<Block> hashChannelB;

    public TwoChannelPagesHashStrategy(List<List<Block>> channels) {
        this.channelA = channels.get(0);
        this.channelB = channels.get(1);
        this.hashChannelA = channels.get(2);
        this.hashChannelB = channels.get(3);
    }

    @Override
    public int getChannelCount() {
        return 2;
    }

    @Override
    public void appendTo(int blockIndex, int blockPosition, PageBuilder pageBuilder, int outputChannelOffset) {
        this.channelA.get(blockIndex).appendTo(blockPosition, pageBuilder.getBlockBuilder(outputChannelOffset + 0));
        this.channelB.get(blockIndex).appendTo(blockPosition, pageBuilder.getBlockBuilder(outputChannelOffset + 1));
    }

    @Override
    public int hashPosition(int blockIndex, int blockPosition) {
        int result = 0;
        result = result * 31 + this.hashChannelA.get(blockIndex).hash(blockPosition);
        result = result * 31 + this.hashChannelB.get(blockIndex).hash(blockPosition);
        return result;
    }

    @Override
    public boolean positionEqualsCursors(int blockIndex, int blockPosition, BlockCursor[] cursors) {
        if (!this.hashChannelA.get(blockIndex).equalTo(blockPosition, cursors[0])) {
            return false;
        }
        return this.hashChannelB.get(blockIndex).equalTo(blockPosition, cursors[1]);
    }

    @Override
    public boolean positionEqualsPosition(int leftBlockIndex, int leftBlockPosition, int rightBlockIndex, int rightBlockPosition) {
        if (!this.hashChannelA.get(leftBlockIndex).equalTo(leftBlockPosition, this.hashChannelA.get(rightBlockIndex), rightBlockPosition)) {
            return false;
        }
        return this.hashChannelB.get(leftBlockIndex).equalTo(leftBlockPosition, this.hashChannelB.get(rightBlockIndex), rightBlockPosition);
    }
}

