/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.JoinProbe;
import com.facebook.presto.operator.JoinProbeFactory;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.google.common.base.Preconditions;

public class TwoChannelJoinProbe
implements JoinProbe {
    private final LookupSource lookupSource;
    private final BlockCursor cursorA;
    private final BlockCursor cursorB;
    private final BlockCursor probeCursorA;
    private final BlockCursor probeCursorB;
    private final BlockCursor[] probeCursors;

    public TwoChannelJoinProbe(LookupSource lookupSource, Page page) {
        this.lookupSource = lookupSource;
        this.cursorA = page.getBlock(0).cursor();
        this.cursorB = page.getBlock(1).cursor();
        this.probeCursorA = this.cursorA;
        this.probeCursorB = this.cursorB;
        this.probeCursors = new BlockCursor[2];
        this.probeCursors[0] = this.probeCursorA;
        this.probeCursors[1] = this.probeCursorB;
    }

    @Override
    public int getChannelCount() {
        return 2;
    }

    @Override
    public void appendTo(PageBuilder pageBuilder) {
        this.cursorA.appendTo(pageBuilder.getBlockBuilder(0));
        this.cursorA.appendTo(pageBuilder.getBlockBuilder(1));
    }

    @Override
    public boolean advanceNextPosition() {
        boolean advanced = this.cursorA.advanceNextPosition();
        Preconditions.checkState((advanced == this.cursorB.advanceNextPosition() ? 1 : 0) != 0);
        return advanced;
    }

    @Override
    public long getCurrentJoinPosition() {
        if (this.currentRowContainsNull()) {
            return -1L;
        }
        return this.lookupSource.getJoinPosition(this.probeCursors);
    }

    private boolean currentRowContainsNull() {
        if (this.probeCursorA.isNull()) {
            return true;
        }
        return this.probeCursorB.isNull();
    }

    public static class TwoChannelJoinProbeFactory
    implements JoinProbeFactory {
        @Override
        public JoinProbe createJoinProbe(LookupSource lookupSource, Page page) {
            return new TwoChannelJoinProbe(lookupSource, page);
        }
    }
}

