/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;

public class TopNOperator
implements Operator {
    private static final int MAX_INITIAL_PRIORITY_QUEUE_SIZE = 10000;
    private static final DataSize OVERHEAD_PER_VALUE = new DataSize(100.0, DataSize.Unit.BYTE);
    private final OperatorContext operatorContext;
    private final List<Type> types;
    private final int n;
    private final List<Integer> sortChannels;
    private final List<SortOrder> sortOrders;
    private final TopNMemoryManager memoryManager;
    private final boolean partial;
    private final Optional<Integer> sampleWeight;
    private final PageBuilder pageBuilder;
    private TopNBuilder topNBuilder;
    private boolean finishing;
    private Iterator<Block[]> outputIterator;

    public TopNOperator(OperatorContext operatorContext, List<Type> types, int n, List<Integer> sortChannels, List<SortOrder> sortOrders, Optional<Integer> sampleWeight, boolean partial) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.types = (List)Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"n must be greater than zero");
        this.n = n;
        this.sortChannels = (List)Preconditions.checkNotNull(sortChannels, (Object)"sortChannels is null");
        this.sortOrders = (List)Preconditions.checkNotNull(sortOrders, (Object)"sortOrders is null");
        this.partial = partial;
        this.memoryManager = new TopNMemoryManager((OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null"));
        this.pageBuilder = new PageBuilder(this.getTypes());
        this.sampleWeight = sampleWeight;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.topNBuilder == null && (this.outputIterator == null || !this.outputIterator.hasNext());
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.outputIterator == null && (this.topNBuilder == null || !this.topNBuilder.isFull());
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        if (this.topNBuilder == null) {
            this.topNBuilder = new TopNBuilder(this.n, this.sortChannels, this.sortOrders, this.sampleWeight, this.memoryManager);
        }
        Preconditions.checkState((!this.topNBuilder.isFull() ? 1 : 0) != 0, (Object)"Aggregation buffer is full");
        this.topNBuilder.processPage(page);
    }

    @Override
    public Page getOutput() {
        if (this.outputIterator == null || !this.outputIterator.hasNext()) {
            if (this.topNBuilder == null) {
                return null;
            }
            if (!this.finishing && !this.topNBuilder.isFull()) {
                return null;
            }
            Preconditions.checkState((this.finishing || this.partial ? 1 : 0) != 0, (String)"Task exceeded max memory size of %s", (Object[])new Object[]{this.memoryManager.getMaxMemorySize()});
            this.outputIterator = this.topNBuilder.build();
            this.topNBuilder = null;
        }
        this.pageBuilder.reset();
        while (!this.pageBuilder.isFull() && this.outputIterator.hasNext()) {
            Block[] next = this.outputIterator.next();
            for (int i = 0; i < next.length; ++i) {
                next[i].appendTo(0, this.pageBuilder.getBlockBuilder(i));
            }
        }
        Page page = this.pageBuilder.build();
        return page;
    }

    private static class RowComparator
    implements Comparator<Block[]> {
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrders;

        public RowComparator(List<Integer> sortChannels, List<SortOrder> sortOrders) {
            Preconditions.checkNotNull(sortChannels, (Object)"sortChannels is null");
            Preconditions.checkNotNull(sortOrders, (Object)"sortOrders is null");
            Preconditions.checkArgument((sortChannels.size() == sortOrders.size() ? 1 : 0) != 0, (String)"sortFields size (%s) doesn't match sortOrders size (%s)", (Object[])new Object[]{sortChannels.size(), sortOrders.size()});
            this.sortChannels = ImmutableList.copyOf(sortChannels);
            this.sortOrders = ImmutableList.copyOf(sortOrders);
        }

        @Override
        public int compare(Block[] leftRow, Block[] rightRow) {
            for (int index = 0; index < this.sortChannels.size(); ++index) {
                Block right;
                SortOrder sortOrder;
                int channel = this.sortChannels.get(index);
                Block left = leftRow[channel];
                int comparison = left.compareTo(sortOrder = this.sortOrders.get(index), 0, right = rightRow[channel], 0);
                if (comparison == 0) continue;
                return comparison;
            }
            return 0;
        }
    }

    public static class TopNMemoryManager {
        private final OperatorContext operatorContext;
        private long currentMemoryReservation;

        public TopNMemoryManager(OperatorContext operatorContext) {
            this.operatorContext = operatorContext;
        }

        public boolean canUse(long memorySize) {
            long delta = (memorySize -= this.operatorContext.getOperatorPreAllocatedMemory().toBytes()) - this.currentMemoryReservation;
            if (delta <= 0L) {
                return false;
            }
            if (!this.operatorContext.reserveMemory(delta)) {
                return true;
            }
            this.currentMemoryReservation = Math.max(this.currentMemoryReservation, memorySize);
            return false;
        }

        public DataSize getMaxMemorySize() {
            return this.operatorContext.getMaxMemorySize();
        }
    }

    private static class TopNBuilder {
        private final int n;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrders;
        private final TopNMemoryManager memoryManager;
        private final PriorityQueue<Block[]> globalCandidates;
        private final Optional<Integer> sampleWeightChannel;
        private long memorySize;

        private TopNBuilder(int n, List<Integer> sortChannels, List<SortOrder> sortOrders, Optional<Integer> sampleWeightChannel, TopNMemoryManager memoryManager) {
            this.n = n;
            this.sortChannels = sortChannels;
            this.sortOrders = sortOrders;
            this.memoryManager = memoryManager;
            this.sampleWeightChannel = sampleWeightChannel;
            Ordering comparator = Ordering.from((Comparator)new RowComparator(sortChannels, sortOrders)).reverse();
            this.globalCandidates = new PriorityQueue(Math.min(n, 10000), comparator);
        }

        public void processPage(Page page) {
            long sizeDelta = this.mergeWithGlobalCandidates(page);
            this.memorySize += sizeDelta;
        }

        private long mergeWithGlobalCandidates(Page page) {
            int i;
            long sizeDelta = 0L;
            BlockCursor[] cursors = new BlockCursor[page.getChannelCount()];
            for (i = 0; i < page.getChannelCount(); ++i) {
                cursors[i] = page.getBlock(i).cursor();
            }
            for (i = 0; i < page.getPositionCount(); ++i) {
                for (BlockCursor cursor : cursors) {
                    Preconditions.checkState((boolean)cursor.advanceNextPosition());
                }
                if (this.globalCandidates.size() < this.n) {
                    sizeDelta += this.addRow(cursors);
                    continue;
                }
                if (this.compare(cursors, this.globalCandidates.peek()) >= 0) continue;
                sizeDelta += this.addRow(cursors);
            }
            return sizeDelta;
        }

        private int compare(BlockCursor[] cursors, Block[] currentMax) {
            for (int i = 0; i < this.sortChannels.size(); ++i) {
                BlockCursor cursor;
                SortOrder sortOrder;
                int sortChannel = this.sortChannels.get(i);
                Block currentMaxValue = currentMax[sortChannel];
                int compare = -currentMaxValue.compareTo(sortOrder = this.sortOrders.get(i), 0, cursor = cursors[sortChannel]);
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }

        private long addRow(BlockCursor[] cursors) {
            long sizeDelta = 0L;
            Block[] row = this.getValues(cursors);
            long sampleWeight = 1L;
            if (this.sampleWeightChannel.isPresent()) {
                sampleWeight = row[(Integer)this.sampleWeightChannel.get()].getLong(0);
                row[((Integer)this.sampleWeightChannel.get()).intValue()] = TopNBuilder.createBigintBlock(1L);
            }
            sizeDelta += this.sizeOfRow(row);
            this.globalCandidates.add(row);
            sizeDelta += (sampleWeight - 1L) * OVERHEAD_PER_VALUE.toBytes();
            int i = 1;
            while ((long)i < sampleWeight) {
                this.globalCandidates.add(row);
                ++i;
            }
            while (this.globalCandidates.size() > this.n) {
                Block[] previous = (Block[])this.globalCandidates.remove();
                if (previous != this.globalCandidates.peek()) {
                    sizeDelta -= this.sizeOfRow(previous);
                    continue;
                }
                sizeDelta -= OVERHEAD_PER_VALUE.toBytes();
            }
            return sizeDelta;
        }

        private long sizeOfRow(Block[] row) {
            long size = OVERHEAD_PER_VALUE.toBytes();
            for (Block value : row) {
                size += (long)value.getSizeInBytes();
            }
            return size;
        }

        private Block[] getValues(BlockCursor[] cursors) {
            Block[] row = new Block[cursors.length];
            for (int i = 0; i < cursors.length; ++i) {
                row[i] = cursors[i].getSingleValueBlock();
            }
            return row;
        }

        private boolean isFull() {
            return this.memoryManager.canUse(this.memorySize);
        }

        public Iterator<Block[]> build() {
            ImmutableList.Builder minSortedGlobalCandidates = ImmutableList.builder();
            long sampleWeight = 1L;
            while (!this.globalCandidates.isEmpty()) {
                Block[] row = (Block[])this.globalCandidates.remove();
                if (this.sampleWeightChannel.isPresent()) {
                    if (this.globalCandidates.peek() != null && row == this.globalCandidates.peek()) {
                        ++sampleWeight;
                        continue;
                    }
                    row[((Integer)this.sampleWeightChannel.get()).intValue()] = TopNBuilder.createBigintBlock(sampleWeight);
                    minSortedGlobalCandidates.add((Object)row);
                    sampleWeight = 1L;
                    continue;
                }
                minSortedGlobalCandidates.add((Object)row);
            }
            return minSortedGlobalCandidates.build().reverse().iterator();
        }

        private static Block createBigintBlock(long value) {
            return BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus()).appendLong(value).build();
        }
    }

    public static class TopNOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<Type> sourceTypes;
        private final int n;
        private final List<Integer> sortChannels;
        private final List<SortOrder> sortOrders;
        private final Optional<Integer> sampleWeight;
        private final boolean partial;
        private boolean closed;

        public TopNOperatorFactory(int operatorId, List<? extends Type> types, int n, List<Integer> sortChannels, List<SortOrder> sortOrders, Optional<Integer> sampleWeight, boolean partial) {
            this.operatorId = operatorId;
            this.sourceTypes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
            this.n = n;
            this.sortChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(sortChannels, (Object)"sortChannels is null")));
            this.sortOrders = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(sortOrders, (Object)"sortOrders is null")));
            this.partial = partial;
            this.sampleWeight = sampleWeight;
        }

        @Override
        public List<Type> getTypes() {
            return this.sourceTypes;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, TopNOperator.class.getSimpleName());
            return new TopNOperator(operatorContext, this.sourceTypes, this.n, this.sortChannels, this.sortOrders, this.sampleWeight, this.partial);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

