/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;

public class TableCommitOperator
implements Operator {
    public static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT);
    private final OperatorContext operatorContext;
    private final TableCommitter tableCommitter;
    private State state = State.RUNNING;
    private long rowCount;
    private final ImmutableList.Builder<String> fragmentBuilder = ImmutableList.builder();

    public TableCommitOperator(OperatorContext operatorContext, TableCommitter tableCommitter) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.tableCommitter = (TableCommitter)Preconditions.checkNotNull((Object)tableCommitter, (Object)"tableCommitter is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return TYPES;
    }

    @Override
    public void finish() {
        if (this.state == State.RUNNING) {
            this.state = State.FINISHING;
        }
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return this.state == State.RUNNING;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((this.state == State.RUNNING ? 1 : 0) != 0, (String)"Operator is %s", (Object[])new Object[]{this.state});
        BlockCursor rowCountCursor = page.getBlock(0).cursor();
        BlockCursor fragmentCursor = page.getBlock(1).cursor();
        for (int i = 0; i < page.getPositionCount(); ++i) {
            Preconditions.checkArgument((boolean)rowCountCursor.advanceNextPosition());
            Preconditions.checkArgument((boolean)fragmentCursor.advanceNextPosition());
            this.rowCount += rowCountCursor.getLong();
            this.fragmentBuilder.add((Object)fragmentCursor.getSlice().toStringUtf8());
        }
    }

    @Override
    public Page getOutput() {
        if (this.state != State.FINISHING) {
            return null;
        }
        this.state = State.FINISHED;
        this.tableCommitter.commitTable((Collection<String>)this.fragmentBuilder.build());
        PageBuilder page = new PageBuilder(this.getTypes());
        page.getBlockBuilder(0).appendLong(this.rowCount);
        return page.build();
    }

    public static interface TableCommitter {
        public void commitTable(Collection<String> var1);
    }

    private static enum State {
        RUNNING,
        FINISHING,
        FINISHED;

    }

    public static class TableCommitOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final TableCommitter tableCommitter;
        private boolean closed;

        public TableCommitOperatorFactory(int operatorId, TableCommitter tableCommitter) {
            this.operatorId = operatorId;
            this.tableCommitter = (TableCommitter)Preconditions.checkNotNull((Object)tableCommitter, (Object)"tableCommitter is null");
        }

        @Override
        public List<Type> getTypes() {
            return TYPES;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, TableCommitOperator.class.getSimpleName());
            return new TableCommitOperator(context, this.tableCommitter);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

