/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.PagesIndexComparator;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.SortOrder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public class SimplePagesIndexComparator
implements PagesIndexComparator {
    private final List<Integer> sortChannels;
    private final List<SortOrder> sortOrders;

    public SimplePagesIndexComparator(List<Integer> sortChannels, List<SortOrder> sortOrders) {
        this.sortChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(sortChannels, (Object)"sortChannels is null")));
        this.sortOrders = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(sortOrders, (Object)"sortOrders is null")));
    }

    @Override
    public int compareTo(PagesIndex pagesIndex, int leftPosition, int rightPosition) {
        long leftPageAddress = pagesIndex.getValueAddresses().getLong(leftPosition);
        int leftBlockIndex = SyntheticAddress.decodeSliceIndex(leftPageAddress);
        int leftBlockPosition = SyntheticAddress.decodePosition(leftPageAddress);
        long rightPageAddress = pagesIndex.getValueAddresses().getLong(rightPosition);
        int rightBlockIndex = SyntheticAddress.decodeSliceIndex(rightPageAddress);
        int rightBlockPosition = SyntheticAddress.decodePosition(rightPageAddress);
        for (int i = 0; i < this.sortChannels.size(); ++i) {
            int sortChannel = this.sortChannels.get(i);
            Block leftBlock = (Block)pagesIndex.getChannel(sortChannel).get(leftBlockIndex);
            Block rightBlock = (Block)pagesIndex.getChannel(sortChannel).get(rightBlockIndex);
            int compare = leftBlock.compareTo(this.sortOrders.get(i), leftBlockPosition, rightBlock, rightBlockPosition);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }
}

