/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.metadata.ColumnHandle;
import com.facebook.presto.operator.AbstractScanFilterAndProjectOperator;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.FilterFunction;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.ProjectionFunction;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.split.DataStreamProvider;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ScanFilterAndProjectOperator
extends AbstractScanFilterAndProjectOperator {
    private final FilterFunction filterFunction;
    private final List<ProjectionFunction> projections;

    public ScanFilterAndProjectOperator(OperatorContext operatorContext, PlanNodeId sourceId, DataStreamProvider dataStreamProvider, Iterable<ColumnHandle> columns, FilterFunction filterFunction, Iterable<? extends ProjectionFunction> projections) {
        super(operatorContext, sourceId, dataStreamProvider, columns, ScanFilterAndProjectOperator.toTypes((List<ProjectionFunction>)ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(projections, (Object)"projections is null")))));
        this.filterFunction = (FilterFunction)Preconditions.checkNotNull((Object)filterFunction, (Object)"filterFunction is null");
        this.projections = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(projections, (Object)"projections is null")));
    }

    @Override
    protected void filterAndProjectRowOriented(Page page, PageBuilder pageBuilder) {
        int rows = page.getPositionCount();
        BlockCursor[] cursors = new BlockCursor[page.getChannelCount()];
        for (int i = 0; i < page.getChannelCount(); ++i) {
            cursors[i] = page.getBlock(i).cursor();
        }
        for (int position = 0; position < rows; ++position) {
            for (BlockCursor cursor : cursors) {
                Preconditions.checkState((boolean)cursor.advanceNextPosition());
            }
            if (!this.filterFunction.filter(cursors)) continue;
            pageBuilder.declarePosition();
            for (int i = 0; i < this.projections.size(); ++i) {
                this.projections.get(i).project(cursors, pageBuilder.getBlockBuilder(i));
            }
        }
        for (BlockCursor cursor : cursors) {
            Preconditions.checkState((!cursor.advanceNextPosition() ? 1 : 0) != 0);
        }
    }

    @Override
    protected int filterAndProjectRowOriented(RecordCursor cursor, PageBuilder pageBuilder) {
        int completedPositions;
        for (completedPositions = 0; completedPositions < 16384 && !pageBuilder.isFull() && cursor.advanceNextPosition(); ++completedPositions) {
            if (!this.filterFunction.filter(cursor)) continue;
            pageBuilder.declarePosition();
            for (int channel = 0; channel < this.projections.size(); ++channel) {
                this.projections.get(channel).project(cursor, pageBuilder.getBlockBuilder(channel));
            }
        }
        return completedPositions;
    }

    private static List<Type> toTypes(List<ProjectionFunction> projections) {
        ImmutableList.Builder types = ImmutableList.builder();
        for (ProjectionFunction projection : projections) {
            types.add((Object)projection.getType());
        }
        return types.build();
    }

    public static class ScanFilterAndProjectOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final DataStreamProvider dataStreamProvider;
        private final List<ColumnHandle> columns;
        private final FilterFunction filterFunction;
        private final List<ProjectionFunction> projections;
        private final List<Type> types;
        private boolean closed;

        public ScanFilterAndProjectOperatorFactory(int operatorId, PlanNodeId sourceId, DataStreamProvider dataStreamProvider, Iterable<ColumnHandle> columns, FilterFunction filterFunction, Iterable<? extends ProjectionFunction> projections) {
            this.operatorId = operatorId;
            this.sourceId = (PlanNodeId)Preconditions.checkNotNull((Object)sourceId, (Object)"sourceId is null");
            this.dataStreamProvider = (DataStreamProvider)Preconditions.checkNotNull((Object)dataStreamProvider, (Object)"dataStreamProvider is null");
            this.columns = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(columns, (Object)"columns is null")));
            this.filterFunction = (FilterFunction)Preconditions.checkNotNull((Object)filterFunction, (Object)"filterFunction is null");
            this.projections = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(projections, (Object)"projections is null")));
            this.types = ScanFilterAndProjectOperator.toTypes(this.projections);
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, FilterAndProjectOperator.class.getSimpleName());
            return new ScanFilterAndProjectOperator(operatorContext, this.sourceId, this.dataStreamProvider, this.columns, this.filterFunction, this.projections);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

