/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.ProjectionFunction;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.tree.Input;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;

public final class ProjectionFunctions {
    private ProjectionFunctions() {
    }

    public static ProjectionFunction singleColumn(Type columnType, int channelIndex) {
        return new SingleColumnProjection(columnType, channelIndex);
    }

    public static ProjectionFunction singleColumn(Type columnType, Input input) {
        return new SingleColumnProjection(columnType, input.getChannel());
    }

    private static class SingleColumnProjection
    implements ProjectionFunction {
        private final Type columnType;
        private final int channelIndex;

        public SingleColumnProjection(Type columnType, int channelIndex) {
            Preconditions.checkNotNull((Object)columnType, (Object)"columnType is null");
            Preconditions.checkArgument((channelIndex >= 0 ? 1 : 0) != 0, (Object)"channelIndex is negative");
            this.columnType = columnType;
            this.channelIndex = channelIndex;
        }

        @Override
        public Type getType() {
            return this.columnType;
        }

        @Override
        public void project(BlockCursor[] cursors, BlockBuilder output) {
            if (cursors[this.channelIndex].isNull()) {
                output.appendNull();
            } else {
                cursors[this.channelIndex].appendTo(output);
            }
        }

        @Override
        public void project(RecordCursor cursor, BlockBuilder output) {
            if (cursor.isNull(this.channelIndex)) {
                output.appendNull();
            } else {
                Class javaType = this.columnType.getJavaType();
                if (javaType == Boolean.TYPE) {
                    output.appendBoolean(cursor.getBoolean(this.channelIndex));
                } else if (javaType == Long.TYPE) {
                    output.appendLong(cursor.getLong(this.channelIndex));
                } else if (javaType == Double.TYPE) {
                    output.appendDouble(cursor.getDouble(this.channelIndex));
                } else if (javaType == Slice.class) {
                    output.appendSlice(cursor.getSlice(this.channelIndex));
                }
            }
        }
    }
}

