/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class OperatorStats {
    private final int operatorId;
    private final String operatorType;
    private final long addInputCalls;
    private final Duration addInputWall;
    private final Duration addInputCpu;
    private final Duration addInputUser;
    private final DataSize inputDataSize;
    private final long inputPositions;
    private final long getOutputCalls;
    private final Duration getOutputWall;
    private final Duration getOutputCpu;
    private final Duration getOutputUser;
    private final DataSize outputDataSize;
    private final long outputPositions;
    private final Duration blockedWall;
    private final long finishCalls;
    private final Duration finishWall;
    private final Duration finishCpu;
    private final Duration finishUser;
    private final DataSize memoryReservation;
    private final Object info;

    @JsonCreator
    public OperatorStats(@JsonProperty(value="operatorId") int operatorId, @JsonProperty(value="operatorType") String operatorType, @JsonProperty(value="addInputCalls") long addInputCalls, @JsonProperty(value="addInputWall") Duration addInputWall, @JsonProperty(value="addInputCpu") Duration addInputCpu, @JsonProperty(value="addInputUser") Duration addInputUser, @JsonProperty(value="inputDataSize") DataSize inputDataSize, @JsonProperty(value="inputPositions") long inputPositions, @JsonProperty(value="getOutputCalls") long getOutputCalls, @JsonProperty(value="getOutputWall") Duration getOutputWall, @JsonProperty(value="getOutputCpu") Duration getOutputCpu, @JsonProperty(value="getOutputUser") Duration getOutputUser, @JsonProperty(value="outputDataSize") DataSize outputDataSize, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="blockedWall") Duration blockedWall, @JsonProperty(value="finishCalls") long finishCalls, @JsonProperty(value="finishWall") Duration finishWall, @JsonProperty(value="finishCpu") Duration finishCpu, @JsonProperty(value="finishUser") Duration finishUser, @JsonProperty(value="memoryReservation") DataSize memoryReservation, @JsonProperty(value="info") Object info) {
        Preconditions.checkArgument((operatorId >= 0 ? 1 : 0) != 0, (Object)"operatorId is negative");
        this.operatorId = operatorId;
        this.operatorType = (String)Preconditions.checkNotNull((Object)operatorType, (Object)"operatorType is null");
        this.addInputCalls = addInputCalls;
        this.addInputWall = (Duration)Preconditions.checkNotNull((Object)addInputWall, (Object)"addInputWall is null");
        this.addInputCpu = (Duration)Preconditions.checkNotNull((Object)addInputCpu, (Object)"addInputCpu is null");
        this.addInputUser = (Duration)Preconditions.checkNotNull((Object)addInputUser, (Object)"addInputUser is null");
        this.inputDataSize = (DataSize)Preconditions.checkNotNull((Object)inputDataSize, (Object)"inputDataSize is null");
        Preconditions.checkArgument((inputPositions >= 0L ? 1 : 0) != 0, (Object)"inputPositions is negative");
        this.inputPositions = inputPositions;
        this.getOutputCalls = getOutputCalls;
        this.getOutputWall = (Duration)Preconditions.checkNotNull((Object)getOutputWall, (Object)"getOutputWall is null");
        this.getOutputCpu = (Duration)Preconditions.checkNotNull((Object)getOutputCpu, (Object)"getOutputCpu is null");
        this.getOutputUser = (Duration)Preconditions.checkNotNull((Object)getOutputUser, (Object)"getOutputUser is null");
        this.outputDataSize = (DataSize)Preconditions.checkNotNull((Object)outputDataSize, (Object)"outputDataSize is null");
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        this.blockedWall = (Duration)Preconditions.checkNotNull((Object)blockedWall, (Object)"blockedWall is null");
        this.finishCalls = finishCalls;
        this.finishWall = (Duration)Preconditions.checkNotNull((Object)finishWall, (Object)"finishWall is null");
        this.finishCpu = (Duration)Preconditions.checkNotNull((Object)finishCpu, (Object)"finishCpu is null");
        this.finishUser = (Duration)Preconditions.checkNotNull((Object)finishUser, (Object)"finishUser is null");
        this.memoryReservation = (DataSize)Preconditions.checkNotNull((Object)memoryReservation, (Object)"memoryReservation is null");
        this.info = info;
    }

    @JsonProperty
    public int getOperatorId() {
        return this.operatorId;
    }

    @JsonProperty
    public String getOperatorType() {
        return this.operatorType;
    }

    @JsonProperty
    public long getAddInputCalls() {
        return this.addInputCalls;
    }

    @JsonProperty
    public Duration getAddInputWall() {
        return this.addInputWall;
    }

    @JsonProperty
    public Duration getAddInputCpu() {
        return this.addInputCpu;
    }

    @JsonProperty
    public Duration getAddInputUser() {
        return this.addInputUser;
    }

    @JsonProperty
    public DataSize getInputDataSize() {
        return this.inputDataSize;
    }

    @JsonProperty
    public long getInputPositions() {
        return this.inputPositions;
    }

    @JsonProperty
    public long getGetOutputCalls() {
        return this.getOutputCalls;
    }

    @JsonProperty
    public Duration getGetOutputWall() {
        return this.getOutputWall;
    }

    @JsonProperty
    public Duration getGetOutputCpu() {
        return this.getOutputCpu;
    }

    @JsonProperty
    public Duration getGetOutputUser() {
        return this.getOutputUser;
    }

    @JsonProperty
    public DataSize getOutputDataSize() {
        return this.outputDataSize;
    }

    @JsonProperty
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    public Duration getBlockedWall() {
        return this.blockedWall;
    }

    @JsonProperty
    public long getFinishCalls() {
        return this.finishCalls;
    }

    @JsonProperty
    public Duration getFinishWall() {
        return this.finishWall;
    }

    @JsonProperty
    public Duration getFinishCpu() {
        return this.finishCpu;
    }

    @JsonProperty
    public Duration getFinishUser() {
        return this.finishUser;
    }

    @JsonProperty
    public DataSize getMemoryReservation() {
        return this.memoryReservation;
    }

    @Nullable
    @JsonProperty
    public Object getInfo() {
        return this.info;
    }

    public OperatorStats add(OperatorStats ... operators) {
        return this.add((Iterable<OperatorStats>)ImmutableList.copyOf((Object[])operators));
    }

    public OperatorStats add(Iterable<OperatorStats> operators) {
        long addInputCalls = this.addInputCalls;
        long addInputWall = this.addInputWall.roundTo(TimeUnit.NANOSECONDS);
        long addInputCpu = this.addInputCpu.roundTo(TimeUnit.NANOSECONDS);
        long addInputUser = this.addInputUser.roundTo(TimeUnit.NANOSECONDS);
        long inputDataSize = this.inputDataSize.toBytes();
        long inputPositions = this.inputPositions;
        long getOutputCalls = this.getOutputCalls;
        long getOutputWall = this.getOutputWall.roundTo(TimeUnit.NANOSECONDS);
        long getOutputCpu = this.getOutputCpu.roundTo(TimeUnit.NANOSECONDS);
        long getOutputUser = this.getOutputUser.roundTo(TimeUnit.NANOSECONDS);
        long outputDataSize = this.outputDataSize.toBytes();
        long outputPositions = this.outputPositions;
        long blockedWall = this.blockedWall.roundTo(TimeUnit.NANOSECONDS);
        long finishCalls = this.finishCalls;
        long finishWall = this.finishWall.roundTo(TimeUnit.NANOSECONDS);
        long finishCpu = this.finishCpu.roundTo(TimeUnit.NANOSECONDS);
        long finishUser = this.finishUser.roundTo(TimeUnit.NANOSECONDS);
        long memoryReservation = this.memoryReservation.toBytes();
        for (OperatorStats operator : operators) {
            Preconditions.checkArgument((operator.getOperatorId() == this.operatorId ? 1 : 0) != 0, (String)"Expected operatorId to be %s but was %s", (Object[])new Object[]{this.operatorId, operator.getOperatorId()});
            addInputCalls += operator.getAddInputCalls();
            addInputWall += operator.getAddInputWall().roundTo(TimeUnit.NANOSECONDS);
            addInputCpu += operator.getAddInputCpu().roundTo(TimeUnit.NANOSECONDS);
            addInputUser += operator.getAddInputUser().roundTo(TimeUnit.NANOSECONDS);
            inputDataSize += operator.getInputDataSize().toBytes();
            inputPositions += operator.getInputPositions();
            getOutputCalls += operator.getGetOutputCalls();
            getOutputWall += operator.getGetOutputWall().roundTo(TimeUnit.NANOSECONDS);
            getOutputCpu += operator.getGetOutputCpu().roundTo(TimeUnit.NANOSECONDS);
            getOutputUser += operator.getGetOutputUser().roundTo(TimeUnit.NANOSECONDS);
            outputDataSize += operator.getOutputDataSize().toBytes();
            outputPositions += operator.getOutputPositions();
            finishCalls += operator.getFinishCalls();
            finishWall += operator.getFinishWall().roundTo(TimeUnit.NANOSECONDS);
            finishCpu += operator.getFinishCpu().roundTo(TimeUnit.NANOSECONDS);
            finishUser += operator.getFinishUser().roundTo(TimeUnit.NANOSECONDS);
            blockedWall += operator.getBlockedWall().roundTo(TimeUnit.NANOSECONDS);
            memoryReservation += operator.getMemoryReservation().toBytes();
        }
        return new OperatorStats(this.operatorId, this.operatorType, addInputCalls, new Duration((double)addInputWall, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)addInputCpu, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)addInputUser, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new DataSize((double)inputDataSize, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), inputPositions, getOutputCalls, new Duration((double)getOutputWall, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)getOutputCpu, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)getOutputUser, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new DataSize((double)outputDataSize, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), outputPositions, new Duration((double)blockedWall, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), finishCalls, new Duration((double)finishWall, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)finishCpu, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)finishUser, TimeUnit.NANOSECONDS).convertToMostSuccinctTimeUnit(), new DataSize((double)memoryReservation, DataSize.Unit.BYTE).convertToMostSuccinctDataSize(), null);
    }
}

