/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class MaterializeSampleOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> types;
    private final int sampleWeightChannel;
    private boolean finishing;
    private BlockCursor[] cursors;
    private BlockCursor sampleWeightCursor;
    private long remainingWeight;
    private PageBuilder pageBuilder;

    public MaterializeSampleOperator(OperatorContext operatorContext, List<Type> types, int sampleWeightChannel) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.sampleWeightChannel = sampleWeightChannel;
        this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        this.pageBuilder = new PageBuilder(types);
        this.cursors = new BlockCursor[types.size()];
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.sampleWeightCursor == null && this.pageBuilder.isEmpty();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.sampleWeightCursor == null;
    }

    @Override
    public void addInput(Page page) {
        int i;
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is finishing");
        Preconditions.checkState((this.sampleWeightCursor == null ? 1 : 0) != 0, (Object)"Current page has not been completely processed yet");
        BlockCursor[] cursors = new BlockCursor[page.getChannelCount()];
        for (i = 0; i < cursors.length; ++i) {
            cursors[i] = page.getBlock(i).cursor();
        }
        this.sampleWeightCursor = cursors[this.sampleWeightChannel];
        int j = 0;
        for (i = 0; i < cursors.length; ++i) {
            if (i == this.sampleWeightChannel) continue;
            this.cursors[j] = cursors[i];
            ++j;
        }
    }

    private boolean advance() {
        boolean advanced;
        if (this.remainingWeight > 0L) {
            --this.remainingWeight;
            return true;
        }
        if (this.sampleWeightCursor == null) {
            return false;
        }
        do {
            advanced = this.sampleWeightCursor.advanceNextPosition();
            for (BlockCursor cursor : this.cursors) {
                Preconditions.checkState((advanced == cursor.advanceNextPosition() ? 1 : 0) != 0);
            }
            Preconditions.checkState((!advanced || !this.sampleWeightCursor.isNull() ? 1 : 0) != 0, (Object)"Encountered NULL sample weight");
        } while (advanced && this.sampleWeightCursor.getLong() == 0L);
        if (!advanced) {
            this.sampleWeightCursor = null;
            Arrays.fill(this.cursors, null);
        } else {
            this.remainingWeight = this.sampleWeightCursor.getLong() - 1L;
        }
        return advanced;
    }

    @Override
    public Page getOutput() {
        while (!this.pageBuilder.isFull() && this.advance()) {
            this.pageBuilder.declarePosition();
            for (int i = 0; i < this.cursors.length; ++i) {
                this.cursors[i].appendTo(this.pageBuilder.getBlockBuilder(i));
            }
        }
        if (this.pageBuilder.isFull() || this.finishing && !this.pageBuilder.isEmpty() && this.sampleWeightCursor == null) {
            Page page = this.pageBuilder.build();
            this.pageBuilder.reset();
            return page;
        }
        return null;
    }

    public static class MaterializeSampleOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final int sampleWeightChannel;
        private final List<Type> types;
        private boolean closed;

        public MaterializeSampleOperatorFactory(int operatorId, List<? extends Type> outputTypes, int sampleWeightChannel) {
            this.operatorId = operatorId;
            this.sampleWeightChannel = sampleWeightChannel;
            this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(outputTypes, (Object)"outputTypes is null")));
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, MaterializeSampleOperator.class.getSimpleName());
            return new MaterializeSampleOperator(operatorContext, this.types, this.sampleWeightChannel);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

