/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import java.util.List;

public class MarkDistinctHash {
    private final GroupByHash groupByHash;
    private long nextDistinctId;

    public MarkDistinctHash(List<Type> types, int[] channels) {
        this(types, channels, 10000);
    }

    public MarkDistinctHash(List<Type> types, int[] channels, int expectedDistinctValues) {
        this.groupByHash = new GroupByHash(types, channels, expectedDistinctValues);
    }

    public long getEstimatedSize() {
        return this.groupByHash.getEstimatedSize();
    }

    public Block markDistinctRows(Page page) {
        BlockBuilder blockBuilder = BooleanType.BOOLEAN.createBlockBuilder(new BlockBuilderStatus());
        GroupByIdBlock ids = this.groupByHash.getGroupIds(page);
        for (int i = 0; i < ids.getPositionCount(); ++i) {
            if (ids.getGroupId(i) == this.nextDistinctId) {
                blockBuilder.appendBoolean(true);
                ++this.nextDistinctId;
                continue;
            }
            blockBuilder.appendBoolean(false);
        }
        return blockBuilder.build();
    }
}

