/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.operator.AggregationFunctionDefinition;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.MemoryManager;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.tree.Input;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HashAggregationOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> groupByTypes;
    private final List<Integer> groupByChannels;
    private final AggregationNode.Step step;
    private final List<AggregationFunctionDefinition> functionDefinitions;
    private final int expectedGroups;
    private final List<Type> types;
    private final MemoryManager memoryManager;
    private GroupByHashAggregationBuilder aggregationBuilder;
    private Iterator<Page> outputIterator;
    private boolean finishing;

    public HashAggregationOperator(OperatorContext operatorContext, List<Type> groupByTypes, List<Integer> groupByChannels, AggregationNode.Step step, List<AggregationFunctionDefinition> functionDefinitions, int expectedGroups) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        Preconditions.checkNotNull((Object)((Object)step), (Object)"step is null");
        Preconditions.checkNotNull(functionDefinitions, (Object)"functionDefinitions is null");
        Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.groupByTypes = groupByTypes;
        this.groupByChannels = groupByChannels;
        this.functionDefinitions = ImmutableList.copyOf(functionDefinitions);
        this.step = step;
        this.expectedGroups = expectedGroups;
        this.memoryManager = new MemoryManager(operatorContext);
        this.types = HashAggregationOperator.toTypes(groupByTypes, step, functionDefinitions);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.aggregationBuilder == null && (this.outputIterator == null || !this.outputIterator.hasNext());
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.outputIterator == null && (this.aggregationBuilder == null || !this.aggregationBuilder.isFull());
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        if (this.aggregationBuilder == null) {
            this.aggregationBuilder = new GroupByHashAggregationBuilder(this.functionDefinitions, this.step, this.expectedGroups, this.groupByTypes, this.groupByChannels, this.memoryManager);
        } else {
            Preconditions.checkState((!this.aggregationBuilder.isFull() ? 1 : 0) != 0, (Object)"Aggregation buffer is full");
        }
        this.aggregationBuilder.processPage(page);
    }

    @Override
    public Page getOutput() {
        if (this.outputIterator == null || !this.outputIterator.hasNext()) {
            if (this.aggregationBuilder == null) {
                return null;
            }
            if (!this.finishing && !this.aggregationBuilder.isFull()) {
                return null;
            }
            if (!this.finishing && this.step != AggregationNode.Step.PARTIAL) {
                throw new ExceededMemoryLimitException(this.memoryManager.getMaxMemorySize());
            }
            this.outputIterator = this.aggregationBuilder.build();
            this.aggregationBuilder = null;
            if (!this.outputIterator.hasNext()) {
                return null;
            }
        }
        return this.outputIterator.next();
    }

    private static List<Type> toTypes(List<? extends Type> groupByType, AggregationNode.Step step, List<AggregationFunctionDefinition> functionDefinitions) {
        ImmutableList.Builder types = ImmutableList.builder();
        types.addAll(groupByType);
        for (AggregationFunctionDefinition functionDefinition : functionDefinitions) {
            if (step != AggregationNode.Step.PARTIAL) {
                types.add((Object)functionDefinition.getFunction().getFinalType());
                continue;
            }
            types.add((Object)functionDefinition.getFunction().getIntermediateType());
        }
        return types.build();
    }

    private static class Aggregator {
        private final GroupedAccumulator aggregation;
        private final AggregationNode.Step step;
        private final int intermediateChannel;

        private Aggregator(AggregationFunctionDefinition functionDefinition, AggregationNode.Step step) {
            AggregationFunction function = functionDefinition.getFunction();
            if (step == AggregationNode.Step.FINAL) {
                Preconditions.checkArgument((functionDefinition.getInputs().size() == 1 ? 1 : 0) != 0, (Object)"Expected a single input for an intermediate aggregation");
                this.intermediateChannel = functionDefinition.getInputs().get(0).getChannel();
                this.aggregation = function.createGroupedIntermediateAggregation(functionDefinition.getConfidence());
            } else {
                int[] argumentChannels = new int[functionDefinition.getInputs().size()];
                for (int i = 0; i < argumentChannels.length; ++i) {
                    argumentChannels[i] = functionDefinition.getInputs().get(i).getChannel();
                }
                this.intermediateChannel = -1;
                this.aggregation = function.createGroupedAggregation((Optional<Integer>)functionDefinition.getMask().transform(Input.channelGetter()), (Optional<Integer>)functionDefinition.getSampleWeight().transform(Input.channelGetter()), functionDefinition.getConfidence(), argumentChannels);
            }
            this.step = step;
        }

        public long getEstimatedSize() {
            return this.aggregation.getEstimatedSize();
        }

        public Type getType() {
            if (this.step == AggregationNode.Step.PARTIAL) {
                return this.aggregation.getIntermediateType();
            }
            return this.aggregation.getFinalType();
        }

        public void processPage(GroupByIdBlock groupIds, Page page) {
            if (this.step == AggregationNode.Step.FINAL) {
                this.aggregation.addIntermediate(groupIds, page.getBlock(this.intermediateChannel));
            } else {
                this.aggregation.addInput(groupIds, page);
            }
        }

        public void evaluate(int groupId, BlockBuilder output) {
            if (this.step == AggregationNode.Step.PARTIAL) {
                this.aggregation.evaluateIntermediate(groupId, output);
            } else {
                this.aggregation.evaluateFinal(groupId, output);
            }
        }
    }

    private static class GroupByHashAggregationBuilder {
        private final GroupByHash groupByHash;
        private final List<Aggregator> aggregators;
        private final MemoryManager memoryManager;

        private GroupByHashAggregationBuilder(List<AggregationFunctionDefinition> functionDefinitions, AggregationNode.Step step, int expectedGroups, List<Type> groupByTypes, List<Integer> groupByChannels, MemoryManager memoryManager) {
            this.groupByHash = new GroupByHash(groupByTypes, Ints.toArray(groupByChannels), expectedGroups);
            this.memoryManager = memoryManager;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (AggregationFunctionDefinition functionDefinition : (List)Preconditions.checkNotNull(functionDefinitions, (Object)"functionDefinitions is null")) {
                builder.add((Object)new Aggregator(functionDefinition, step));
            }
            this.aggregators = builder.build();
        }

        private void processPage(Page page) {
            GroupByIdBlock groupIds = this.groupByHash.getGroupIds(page);
            for (Aggregator aggregator : this.aggregators) {
                aggregator.processPage(groupIds, page);
            }
        }

        public boolean isFull() {
            long memorySize = this.groupByHash.getEstimatedSize();
            for (Aggregator aggregator : this.aggregators) {
                memorySize += aggregator.getEstimatedSize();
            }
            return !this.memoryManager.canUse(memorySize);
        }

        public Iterator<Page> build() {
            ArrayList<Type> types = new ArrayList<Type>(this.groupByHash.getTypes());
            for (Aggregator aggregator : this.aggregators) {
                types.add(aggregator.getType());
            }
            final PageBuilder pageBuilder = new PageBuilder(types);
            return new AbstractIterator<Page>(){
                private final int groupCount;
                private int groupId;
                {
                    this.groupCount = GroupByHashAggregationBuilder.this.groupByHash.getGroupCount();
                }

                protected Page computeNext() {
                    int i;
                    if (this.groupId >= this.groupCount) {
                        return (Page)this.endOfData();
                    }
                    pageBuilder.reset();
                    List<Type> types = GroupByHashAggregationBuilder.this.groupByHash.getTypes();
                    BlockBuilder[] groupByBlockBuilders = new BlockBuilder[types.size()];
                    for (i = 0; i < types.size(); ++i) {
                        groupByBlockBuilders[i] = pageBuilder.getBlockBuilder(i);
                    }
                    while (!pageBuilder.isFull() && this.groupId < this.groupCount) {
                        GroupByHashAggregationBuilder.this.groupByHash.appendValuesTo(this.groupId, groupByBlockBuilders);
                        for (i = 0; i < GroupByHashAggregationBuilder.this.aggregators.size(); ++i) {
                            Aggregator aggregator = (Aggregator)GroupByHashAggregationBuilder.this.aggregators.get(i);
                            BlockBuilder output = pageBuilder.getBlockBuilder(types.size() + i);
                            aggregator.evaluate(this.groupId, output);
                        }
                        ++this.groupId;
                    }
                    Page page = pageBuilder.build();
                    return page;
                }
            };
        }
    }

    public static class HashAggregationOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final List<Type> groupByTypes;
        private final List<Integer> groupByChannels;
        private final AggregationNode.Step step;
        private final List<AggregationFunctionDefinition> functionDefinitions;
        private final int expectedGroups;
        private final List<Type> types;
        private boolean closed;

        public HashAggregationOperatorFactory(int operatorId, List<? extends Type> groupByTypes, List<Integer> groupByChannels, AggregationNode.Step step, List<AggregationFunctionDefinition> functionDefinitions, int expectedGroups) {
            this.operatorId = operatorId;
            this.groupByTypes = ImmutableList.copyOf(groupByTypes);
            this.groupByChannels = groupByChannels;
            this.step = step;
            this.functionDefinitions = functionDefinitions;
            this.expectedGroups = expectedGroups;
            this.types = HashAggregationOperator.toTypes(groupByTypes, step, functionDefinitions);
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, HashAggregationOperator.class.getSimpleName());
            return new HashAggregationOperator(operatorContext, this.groupByTypes, this.groupByChannels, this.step, this.functionDefinitions, this.expectedGroups);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

