/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.ExchangeClient;
import com.facebook.presto.operator.ExchangeClientConfig;
import com.facebook.presto.operator.ForExchange;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import io.airlift.http.client.HttpClient;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;

public class ExchangeClientFactory
implements Supplier<ExchangeClient> {
    private final BlockEncodingSerde blockEncodingSerde;
    private final DataSize maxBufferedBytes;
    private final int concurrentRequestMultiplier;
    private final Duration minErrorDuration;
    private final HttpClient httpClient;
    private final DataSize maxResponseSize;
    private final ScheduledExecutorService executor;

    @Inject
    public ExchangeClientFactory(BlockEncodingSerde blockEncodingSerde, ExchangeClientConfig config, @ForExchange HttpClient httpClient, @ForExchange ScheduledExecutorService executor) {
        this(blockEncodingSerde, config.getMaxBufferSize(), config.getMaxResponseSize(), config.getConcurrentRequestMultiplier(), config.getMinErrorDuration(), httpClient, executor);
    }

    public ExchangeClientFactory(BlockEncodingSerde blockEncodingSerde, DataSize maxBufferedBytes, DataSize maxResponseSize, int concurrentRequestMultiplier, Duration minErrorDuration, HttpClient httpClient, ScheduledExecutorService executor) {
        this.blockEncodingSerde = blockEncodingSerde;
        this.maxBufferedBytes = (DataSize)Preconditions.checkNotNull((Object)maxBufferedBytes, (Object)"maxBufferedBytes is null");
        this.concurrentRequestMultiplier = concurrentRequestMultiplier;
        this.minErrorDuration = (Duration)Preconditions.checkNotNull((Object)minErrorDuration, (Object)"minErrorDuration is null");
        this.httpClient = (HttpClient)Preconditions.checkNotNull((Object)httpClient, (Object)"httpClient is null");
        this.maxResponseSize = (DataSize)Preconditions.checkNotNull((Object)maxResponseSize, (Object)"maxResponseSize is null");
        this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        Preconditions.checkArgument((maxBufferedBytes.toBytes() > 0L ? 1 : 0) != 0, (String)"maxBufferSize must be at least 1 byte: %s", (Object[])new Object[]{maxBufferedBytes});
        Preconditions.checkArgument((maxResponseSize.toBytes() > 0L ? 1 : 0) != 0, (String)"maxResponseSize must be at least 1 byte: %s", (Object[])new Object[]{maxResponseSize});
        Preconditions.checkArgument((concurrentRequestMultiplier > 0 ? 1 : 0) != 0, (String)"concurrentRequestMultiplier must be at least 1: %s", (Object[])new Object[]{concurrentRequestMultiplier});
    }

    public ExchangeClient get() {
        return new ExchangeClient(this.blockEncodingSerde, this.maxBufferedBytes, this.maxResponseSize, this.concurrentRequestMultiplier, this.minErrorDuration, this.httpClient, this.executor);
    }
}

