/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongHash;
import it.unimi.dsi.fastutil.longs.LongOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;

public class ChannelSet {
    public static final long CURRENT_VALUE_ADDRESS = -1L;
    private final BlockBuilderHashStrategy strategy;
    private final AddressValueSet addressValueSet;
    private final boolean containsNull;
    private final DataSize estimatedSize;

    public ChannelSet(ChannelSet channelSet) {
        Preconditions.checkNotNull((Object)channelSet, (Object)"channelSet is null");
        this.strategy = new BlockBuilderHashStrategy(channelSet.strategy);
        this.addressValueSet = new AddressValueSet(channelSet.addressValueSet, (LongHash.Strategy)this.strategy);
        this.containsNull = channelSet.containsNull;
        this.estimatedSize = channelSet.estimatedSize;
    }

    private ChannelSet(BlockBuilderHashStrategy strategy, AddressValueSet addressValueSet, boolean containsNull, DataSize estimatedSize) {
        this.strategy = strategy;
        this.addressValueSet = addressValueSet;
        this.containsNull = containsNull;
        this.estimatedSize = estimatedSize;
    }

    public boolean containsNull() {
        return this.containsNull;
    }

    public void setCurrentValue(BlockCursor value) {
        this.strategy.setLookupValue(value);
    }

    public boolean containsCurrentValue() {
        return this.addressValueSet.contains(-1L);
    }

    public int size() {
        return this.addressValueSet.size();
    }

    public DataSize getEstimatedSize() {
        return this.estimatedSize;
    }

    private static class BlockBuilderHashStrategy
    implements LongHash.Strategy {
        private final List<BlockBuilder> blocks;
        private BlockCursor lookupValue;

        public BlockBuilderHashStrategy(BlockBuilderHashStrategy strategy) {
            this(((BlockBuilderHashStrategy)Preconditions.checkNotNull((Object)strategy, (Object)"strategy is null")).blocks);
        }

        private BlockBuilderHashStrategy(List<BlockBuilder> blocks) {
            Preconditions.checkNotNull(blocks, (Object)"blocks is null");
            this.blocks = blocks;
        }

        public void setLookupValue(BlockCursor lookupValue) {
            Preconditions.checkNotNull((Object)lookupValue, (Object)"lookupValue is null");
            this.lookupValue = lookupValue;
        }

        public int hashCode(long sliceAddress) {
            if (sliceAddress == -1L) {
                return this.hashCurrentRow();
            }
            return this.hashPosition(sliceAddress);
        }

        private int hashPosition(long sliceAddress) {
            int sliceIndex = SyntheticAddress.decodeSliceIndex(sliceAddress);
            int position = SyntheticAddress.decodePosition(sliceAddress);
            return this.blocks.get(sliceIndex).hash(position);
        }

        private int hashCurrentRow() {
            return this.lookupValue.hash();
        }

        public boolean equals(long leftSliceAddress, long rightSliceAddress) {
            if (leftSliceAddress == -1L && rightSliceAddress == -1L) {
                return true;
            }
            if (leftSliceAddress == -1L) {
                return this.positionEqualsCurrentRow(SyntheticAddress.decodeSliceIndex(rightSliceAddress), SyntheticAddress.decodePosition(rightSliceAddress));
            }
            if (rightSliceAddress == -1L) {
                return this.positionEqualsCurrentRow(SyntheticAddress.decodeSliceIndex(leftSliceAddress), SyntheticAddress.decodePosition(leftSliceAddress));
            }
            return this.positionEqualsPosition(SyntheticAddress.decodeSliceIndex(leftSliceAddress), SyntheticAddress.decodePosition(leftSliceAddress), SyntheticAddress.decodeSliceIndex(rightSliceAddress), SyntheticAddress.decodePosition(rightSliceAddress));
        }

        private boolean positionEqualsCurrentRow(int sliceIndex, int position) {
            return this.blocks.get(sliceIndex).equalTo(position, this.lookupValue);
        }

        private boolean positionEqualsPosition(int leftSliceIndex, int leftPosition, int rightSliceIndex, int rightPosition) {
            return this.blocks.get(leftSliceIndex).equalTo(leftPosition, (Block)this.blocks.get(rightSliceIndex), rightPosition);
        }
    }

    public static class ChannelSetBuilder {
        private final BlockBuilderHashStrategy strategy;
        private final AddressValueSet addressValueSet;
        private final OperatorContext operatorContext;
        private final Type type;
        private final ObjectArrayList<BlockBuilder> blocks;
        private int currentBlockId;
        private boolean containsNull;
        private BlockBuilder openBlockBuilder;
        private long blocksMemorySize;

        public ChannelSetBuilder(Type type, int expectedPositions, OperatorContext operatorContext) {
            this.type = (Type)Preconditions.checkNotNull((Object)type, (Object)"type is null");
            Preconditions.checkArgument((expectedPositions >= 0 ? 1 : 0) != 0, (Object)"expectedPositions must be greater than or equal to zero");
            this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
            this.blocks = ObjectArrayList.wrap((Object[])new BlockBuilder[1024], (int)0);
            this.strategy = new BlockBuilderHashStrategy((List)this.blocks);
            this.addressValueSet = new AddressValueSet(expectedPositions, (LongHash.Strategy)this.strategy);
            this.openBlockBuilder = type.createBlockBuilder(new BlockBuilderStatus());
            this.blocks.add((Object)this.openBlockBuilder);
        }

        public void addBlock(Block sourceBlock) {
            BlockCursor sourceCursor = sourceBlock.cursor();
            this.strategy.setLookupValue(sourceCursor);
            while (sourceCursor.advanceNextPosition()) {
                this.containsNull |= sourceCursor.isNull();
                if (this.addressValueSet.contains(-1L)) continue;
                if (this.openBlockBuilder.isFull()) {
                    this.blocksMemorySize += (long)this.openBlockBuilder.getSizeInBytes();
                    this.openBlockBuilder = this.type.createBlockBuilder(new BlockBuilderStatus());
                    this.blocks.add((Object)this.openBlockBuilder);
                    ++this.currentBlockId;
                }
                int blockPosition = this.openBlockBuilder.getPositionCount();
                sourceCursor.appendTo(this.openBlockBuilder);
                this.addressValueSet.add(SyntheticAddress.encodeSyntheticAddress(this.currentBlockId, blockPosition));
            }
            this.operatorContext.setMemoryReservation(this.getEstimatedSize());
        }

        public long getEstimatedSize() {
            return this.blocksMemorySize;
        }

        public ChannelSet build() {
            DataSize estimatedSize = new DataSize((double)(this.addressValueSet.getEstimatedSize().toBytes() + this.blocksMemorySize + (long)this.openBlockBuilder.getSizeInBytes()), DataSize.Unit.BYTE);
            return new ChannelSet(this.strategy, this.addressValueSet, this.containsNull, estimatedSize);
        }
    }

    private static class AddressValueSet
    extends LongOpenCustomHashSet {
        private AddressValueSet(int expected, LongHash.Strategy strategy) {
            super(expected, strategy);
        }

        private AddressValueSet(AddressValueSet addressValueSet, LongHash.Strategy strategy) {
            super((LongCollection)addressValueSet, strategy);
        }

        public DataSize getEstimatedSize() {
            return new DataSize((double)(SizeOf.sizeOf((long[])this.key) + SizeOf.sizeOf((boolean[])this.used)), DataSize.Unit.BYTE);
        }
    }
}

