/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.Page;
import com.facebook.presto.operator.PageBuilder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;

public abstract class AbstractFilterAndProjectOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> types;
    private final PageBuilder pageBuilder;
    private boolean finishing;

    public AbstractFilterAndProjectOperator(OperatorContext operatorContext, Iterable<? extends Type> types) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.types = ImmutableList.copyOf((Iterable)((Iterable)Preconditions.checkNotNull(types, (Object)"types is null")));
        this.pageBuilder = new PageBuilder(this.getTypes());
    }

    protected abstract void filterAndProjectRowOriented(Page var1, PageBuilder var2);

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public final List<Type> getTypes() {
        return this.types;
    }

    @Override
    public final void finish() {
        this.finishing = true;
    }

    @Override
    public final boolean isFinished() {
        return this.finishing && this.pageBuilder.isEmpty();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public final boolean needsInput() {
        return !this.finishing && !this.pageBuilder.isFull();
    }

    @Override
    public final void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkNotNull((Object)page, (Object)"page is null");
        Preconditions.checkState((!this.pageBuilder.isFull() ? 1 : 0) != 0, (Object)"Page buffer is full");
        this.filterAndProjectRowOriented(page, this.pageBuilder);
    }

    @Override
    public final Page getOutput() {
        if (this.needsInput() || this.pageBuilder.isEmpty()) {
            return null;
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return page;
    }
}

