/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public final class Signature {
    private final String name;
    private final Type returnType;
    private final List<Type> argumentTypes;
    private final boolean approximate;
    private final boolean operator;

    @JsonCreator
    public Signature(@JsonProperty(value="name") String name, @JsonProperty(value="returnType") Type returnType, @JsonProperty(value="argumentTypes") List<? extends Type> argumentTypes, @JsonProperty(value="approximate") boolean approximate, @JsonProperty(value="operator") boolean operator) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull((Object)returnType, (Object)"returnType is null");
        Preconditions.checkNotNull(argumentTypes, (Object)"argumentTypes is null");
        this.name = name;
        this.returnType = returnType;
        this.argumentTypes = ImmutableList.copyOf(argumentTypes);
        this.approximate = approximate;
        this.operator = operator;
    }

    public Signature(String name, Type returnType, Type ... argumentTypes) {
        this(name.toLowerCase(), returnType, (List<? extends Type>)ImmutableList.copyOf((Object[])argumentTypes), false, false);
    }

    public Signature(String name, Type returnType, List<? extends Type> argumentTypes, boolean approximate) {
        this(name, returnType, argumentTypes, approximate, false);
    }

    @JsonProperty
    public boolean isApproximate() {
        return this.approximate;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Type getReturnType() {
        return this.returnType;
    }

    @JsonProperty
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    @JsonProperty
    public boolean isOperator() {
        return this.operator;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.returnType, this.argumentTypes, this.approximate, this.operator);
    }

    Signature withAlias(String name) {
        return new Signature(name, this.returnType, this.argumentTypes, this.approximate, this.operator);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Signature other = (Signature)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.returnType, other.returnType) && Objects.equals(this.argumentTypes, other.argumentTypes) && Objects.equals(this.approximate, other.approximate) && Objects.equals(this.operator, other.operator);
    }

    public String toString() {
        return (this.operator ? "%" : "") + this.name + (this.approximate ? "[approximate]" : "") + "(" + Joiner.on((String)",").join(this.argumentTypes) + "):" + this.returnType;
    }
}

