/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public class OperatorNotFoundException
extends PrestoException {
    private final OperatorType operatorType;
    private final Type returnType;
    private final List<Type> argumentTypes;

    public OperatorNotFoundException(OperatorType operatorType, List<? extends Type> argumentTypes) {
        super(StandardErrorCode.OPERATOR_NOT_FOUND.toErrorCode(), String.format("Operator %s(%s) not registered", new Object[]{operatorType, Joiner.on((String)", ").join(argumentTypes)}));
        this.operatorType = (OperatorType)((Object)Preconditions.checkNotNull((Object)((Object)operatorType), (Object)"operatorType is null"));
        this.returnType = null;
        this.argumentTypes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(argumentTypes, (Object)"argumentTypes is null")));
    }

    public OperatorNotFoundException(OperatorType operatorType, List<? extends Type> argumentTypes, Type returnType) {
        super(StandardErrorCode.OPERATOR_NOT_FOUND.toErrorCode(), String.format("Operator %s(%s):%s not registered", new Object[]{operatorType, Joiner.on((String)", ").join(argumentTypes), returnType}));
        this.operatorType = (OperatorType)((Object)Preconditions.checkNotNull((Object)((Object)operatorType), (Object)"operatorType is null"));
        this.argumentTypes = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(argumentTypes, (Object)"argumentTypes is null")));
        this.returnType = (Type)Preconditions.checkNotNull((Object)returnType, (Object)"returnType is null");
    }

    public OperatorType getOperatorType() {
        return this.operatorType;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }
}

