/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.TaskSource;
import com.facebook.presto.event.query.QueryMonitor;
import com.facebook.presto.execution.AbandonedException;
import com.facebook.presto.execution.BufferInfo;
import com.facebook.presto.execution.BufferResult;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.SharedBuffer;
import com.facebook.presto.execution.SharedBufferInfo;
import com.facebook.presto.execution.SqlTaskExecution;
import com.facebook.presto.execution.TaskExecution;
import com.facebook.presto.execution.TaskExecutor;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManager;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class SqlTaskManager
implements TaskManager {
    private static final Logger log = Logger.get(SqlTaskManager.class);
    private final DataSize maxBufferSize;
    private final ExecutorService taskNotificationExecutor;
    private final ThreadPoolExecutorMBean taskNotificationExecutorMBean;
    private final TaskExecutor taskExecutor;
    private final ScheduledExecutorService taskManagementExecutor;
    private final ThreadPoolExecutorMBean taskManagementExecutorMBean;
    private final LocalExecutionPlanner planner;
    private final LocationFactory locationFactory;
    private final QueryMonitor queryMonitor;
    private final DataSize maxTaskMemoryUsage;
    private final DataSize operatorPreAllocatedMemory;
    private final Duration infoCacheTime;
    private final Duration clientTimeout;
    private final boolean cpuTimerEnabled;
    private final ConcurrentMap<TaskId, TaskInfo> taskInfos = new ConcurrentHashMap<TaskId, TaskInfo>();
    private final ConcurrentMap<TaskId, TaskExecution> tasks = new ConcurrentHashMap<TaskId, TaskExecution>();
    private final CounterStat inputDataSize = new CounterStat();
    private final CounterStat finishedInputDataSize = new CounterStat();
    private final CounterStat inputPositions = new CounterStat();
    private final CounterStat finishedInputPositions = new CounterStat();
    private final CounterStat outputDataSize = new CounterStat();
    private final CounterStat finishedOutputDataSize = new CounterStat();
    private final CounterStat outputPositions = new CounterStat();
    private final CounterStat finishedOutputPositions = new CounterStat();

    @Inject
    public SqlTaskManager(LocalExecutionPlanner planner, LocationFactory locationFactory, TaskExecutor taskExecutor, QueryMonitor queryMonitor, TaskManagerConfig config) {
        this.planner = (LocalExecutionPlanner)Preconditions.checkNotNull((Object)planner, (Object)"planner is null");
        this.locationFactory = (LocationFactory)Preconditions.checkNotNull((Object)locationFactory, (Object)"locationFactory is null");
        this.taskExecutor = (TaskExecutor)Preconditions.checkNotNull((Object)taskExecutor, (Object)"taskExecutor is null");
        this.queryMonitor = (QueryMonitor)Preconditions.checkNotNull((Object)queryMonitor, (Object)"queryMonitor is null");
        Preconditions.checkNotNull((Object)config, (Object)"config is null");
        this.maxBufferSize = config.getSinkMaxBufferSize();
        this.maxTaskMemoryUsage = config.getMaxTaskMemoryUsage();
        this.operatorPreAllocatedMemory = config.getOperatorPreAllocatedMemory();
        this.infoCacheTime = config.getInfoMaxAge();
        this.clientTimeout = config.getClientTimeout();
        this.cpuTimerEnabled = config.isTaskCpuTimerEnabled();
        this.taskNotificationExecutor = Executors.newCachedThreadPool(Threads.threadsNamed((String)"task-notification-%d"));
        this.taskNotificationExecutorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.taskNotificationExecutor);
        this.taskManagementExecutor = Executors.newScheduledThreadPool(5, Threads.threadsNamed((String)"task-management-%d"));
        this.taskManagementExecutorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)((Object)this.taskManagementExecutor));
    }

    @PostConstruct
    public void start() {
        this.taskManagementExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    SqlTaskManager.this.removeOldTasks();
                }
                catch (Throwable e) {
                    log.warn(e, "Error removing old tasks");
                }
                try {
                    SqlTaskManager.this.failAbandonedTasks();
                }
                catch (Throwable e) {
                    log.warn(e, "Error canceling abandoned tasks");
                }
            }
        }, 200L, 200L, TimeUnit.MILLISECONDS);
        this.taskManagementExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    SqlTaskManager.this.updateStats();
                }
                catch (Throwable e) {
                    log.warn(e, "Error updating stats");
                }
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void stop() {
        this.taskNotificationExecutor.shutdownNow();
        this.taskManagementExecutor.shutdownNow();
    }

    @Managed
    @Nested
    public CounterStat getInputDataSize() {
        return this.inputDataSize;
    }

    @Managed
    @Nested
    public CounterStat getInputPositions() {
        return this.inputPositions;
    }

    @Managed
    @Nested
    public CounterStat getOutputDataSize() {
        return this.outputDataSize;
    }

    @Managed
    @Nested
    public CounterStat getOutputPositions() {
        return this.outputPositions;
    }

    @Managed(description="Task notification executor")
    @Nested
    public ThreadPoolExecutorMBean getTaskNotificationExecutor() {
        return this.taskNotificationExecutorMBean;
    }

    @Managed(description="Task garbage collector executor")
    @Nested
    public ThreadPoolExecutorMBean getTaskManagementExecutor() {
        return this.taskManagementExecutorMBean;
    }

    @Override
    public List<TaskInfo> getAllTaskInfo() {
        HashMap<TaskId, TaskInfo> taskInfos = new HashMap<TaskId, TaskInfo>();
        for (TaskExecution taskExecution : this.tasks.values()) {
            taskInfos.put(taskExecution.getTaskId(), this.getTaskInfo(taskExecution));
        }
        taskInfos.putAll(this.taskInfos);
        return ImmutableList.copyOf(taskInfos.values());
    }

    @Override
    public void waitForStateChange(TaskId taskId, TaskState currentState, Duration maxWait) throws InterruptedException {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        Preconditions.checkNotNull((Object)maxWait, (Object)"maxWait is null");
        TaskExecution taskExecution = (TaskExecution)this.tasks.get(taskId);
        if (taskExecution == null) {
            return;
        }
        taskExecution.recordHeartbeat();
        taskExecution.waitForStateChange(currentState, maxWait);
    }

    @Override
    public TaskInfo getTaskInfo(TaskId taskId) {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        TaskExecution taskExecution = (TaskExecution)this.tasks.get(taskId);
        if (taskExecution != null) {
            taskExecution.recordHeartbeat();
            return this.getTaskInfo(taskExecution);
        }
        TaskInfo taskInfo = (TaskInfo)this.taskInfos.get(taskId);
        if (taskInfo == null) {
            throw new NoSuchElementException("Unknown query task " + taskId);
        }
        return taskInfo;
    }

    private TaskInfo getTaskInfo(TaskExecution taskExecution) {
        TaskInfo taskInfo = taskExecution.getTaskInfo();
        if (taskInfo.getState().isDone()) {
            if (taskInfo.getStats().getEndTime() == null) {
                log.warn("Task %s is in done state %s but does not have an end time", new Object[]{taskInfo.getTaskId(), taskInfo.getState()});
            }
            this.taskInfos.putIfAbsent(taskInfo.getTaskId(), taskInfo);
            TaskContext taskContext = taskExecution.getTaskContext();
            this.finishedInputDataSize.merge(taskContext.getInputDataSize());
            this.finishedInputPositions.merge(taskContext.getInputPositions());
            this.finishedOutputDataSize.merge(taskContext.getOutputDataSize());
            this.finishedOutputPositions.merge(taskContext.getOutputPositions());
            this.tasks.remove(taskInfo.getTaskId());
        }
        return taskInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskInfo updateTask(ConnectorSession session, TaskId taskId, PlanFragment fragment, List<TaskSource> sources, OutputBuffers outputBuffers) {
        TaskExecution taskExecution;
        URI location = this.locationFactory.createLocalTaskLocation(taskId);
        SqlTaskManager sqlTaskManager = this;
        synchronized (sqlTaskManager) {
            taskExecution = (TaskExecution)this.tasks.get(taskId);
            if (taskExecution == null) {
                TaskInfo taskInfo = (TaskInfo)this.taskInfos.get(taskId);
                if (taskInfo != null) {
                    return taskInfo;
                }
                taskExecution = SqlTaskExecution.createSqlTaskExecution(session, taskId, location, fragment, sources, outputBuffers, this.planner, this.maxBufferSize, this.taskExecutor, this.taskNotificationExecutor, this.maxTaskMemoryUsage, this.operatorPreAllocatedMemory, this.queryMonitor, this.cpuTimerEnabled);
                this.tasks.put(taskId, taskExecution);
            }
        }
        taskExecution.recordHeartbeat();
        taskExecution.addSources(sources);
        taskExecution.addResultQueue(outputBuffers);
        return this.getTaskInfo(taskExecution);
    }

    @Override
    public BufferResult getTaskResults(TaskId taskId, String outputName, long startingSequenceId, DataSize maxSize, Duration maxWaitTime) throws InterruptedException {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        Preconditions.checkNotNull((Object)outputName, (Object)"outputName is null");
        Preconditions.checkArgument((maxSize.toBytes() > 0L ? 1 : 0) != 0, (Object)"maxSize must be at least 1 byte");
        Preconditions.checkNotNull((Object)maxWaitTime, (Object)"maxWaitTime is null");
        TaskExecution taskExecution = (TaskExecution)this.tasks.get(taskId);
        if (taskExecution == null) {
            TaskInfo taskInfo = (TaskInfo)this.taskInfos.get(taskId);
            if (taskInfo == null) {
                throw new NoSuchElementException("Unknown query task " + taskId);
            }
            if (taskInfo.getState() == TaskState.FAILED) {
                Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                return BufferResult.emptyResults(startingSequenceId, false);
            }
            return BufferResult.emptyResults(taskInfo.getOutputBuffers().getMasterSequenceId(), true);
        }
        taskExecution.recordHeartbeat();
        return taskExecution.getResults(outputName, startingSequenceId, maxSize, maxWaitTime);
    }

    @Override
    public TaskInfo abortTaskResults(TaskId taskId, String outputId) {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        Preconditions.checkNotNull((Object)outputId, (Object)"outputId is null");
        TaskExecution taskExecution = (TaskExecution)this.tasks.get(taskId);
        if (taskExecution == null) {
            TaskInfo taskInfo = (TaskInfo)this.taskInfos.get(taskId);
            if (taskInfo != null) {
                return taskInfo;
            }
            throw new NoSuchElementException("Unknown query task " + taskId);
        }
        log.debug("Aborting task %s output %s", new Object[]{taskId, outputId});
        taskExecution.abortResults(outputId);
        return this.getTaskInfo(taskExecution);
    }

    @Override
    public TaskInfo cancelTask(TaskId taskId) {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        TaskExecution taskExecution = (TaskExecution)this.tasks.get(taskId);
        if (taskExecution == null) {
            TaskInfo taskInfo = (TaskInfo)this.taskInfos.get(taskId);
            if (taskInfo == null) {
                TaskContext taskContext = new TaskContext(new TaskStateMachine(taskId, this.taskNotificationExecutor), this.taskManagementExecutor, null, this.maxTaskMemoryUsage, this.operatorPreAllocatedMemory, this.cpuTimerEnabled);
                taskInfo = new TaskInfo(taskId, Long.MAX_VALUE, TaskState.CANCELED, URI.create("unknown"), DateTime.now(), new SharedBufferInfo(SharedBuffer.QueueState.FINISHED, 0L, 0L, (List<BufferInfo>)ImmutableList.of()), (Set<PlanNodeId>)ImmutableSet.of(), taskContext.getTaskStats(), (List<ExecutionFailureInfo>)ImmutableList.of());
                TaskInfo existingTaskInfo = this.taskInfos.putIfAbsent(taskId, taskInfo);
                if (existingTaskInfo != null) {
                    taskInfo = existingTaskInfo;
                }
            }
            return taskInfo;
        }
        taskExecution.cancel();
        return this.getTaskInfo(taskExecution);
    }

    public void removeOldTasks() {
        DateTime oldestAllowedTask = DateTime.now().minus(this.infoCacheTime.toMillis());
        for (TaskInfo taskInfo : this.taskInfos.values()) {
            try {
                DateTime endTime = taskInfo.getStats().getEndTime();
                if (endTime == null || !endTime.isBefore((ReadableInstant)oldestAllowedTask)) continue;
                this.taskInfos.remove(taskInfo.getTaskId());
            }
            catch (RuntimeException e) {
                log.warn((Throwable)e, "Error while inspecting age of complete task %s", new Object[]{taskInfo.getTaskId()});
            }
        }
    }

    public void failAbandonedTasks() {
        DateTime now = DateTime.now();
        DateTime oldestAllowedHeartbeat = now.minus(this.clientTimeout.toMillis());
        for (TaskExecution taskExecution : this.tasks.values()) {
            try {
                DateTime lastHeartbeat;
                TaskInfo taskInfo = taskExecution.getTaskInfo();
                if (taskInfo.getState().isDone() || (lastHeartbeat = taskInfo.getLastHeartbeat()) == null || !lastHeartbeat.isBefore((ReadableInstant)oldestAllowedHeartbeat)) continue;
                log.info("Failing abandoned task %s", new Object[]{taskExecution.getTaskId()});
                taskExecution.fail((Throwable)((Object)new AbandonedException("Task " + taskInfo.getTaskId(), lastHeartbeat, now)));
                this.getTaskInfo(taskExecution);
            }
            catch (RuntimeException e) {
                log.warn((Throwable)e, "Error while inspecting age of task %s", new Object[]{taskExecution.getTaskId()});
            }
        }
    }

    private void updateStats() {
        TaskContext taskContext;
        CounterStat temp = new CounterStat();
        temp.merge(this.finishedInputDataSize);
        for (TaskExecution taskExecution : this.tasks.values()) {
            taskContext = taskExecution.getTaskContext();
            temp.merge(taskContext.getInputDataSize());
        }
        this.inputDataSize.resetTo(temp);
        temp = new CounterStat();
        temp.merge(this.finishedInputPositions);
        for (TaskExecution taskExecution : this.tasks.values()) {
            taskContext = taskExecution.getTaskContext();
            temp.merge(taskContext.getInputPositions());
        }
        this.inputPositions.resetTo(temp);
        temp = new CounterStat();
        temp.merge(this.finishedOutputDataSize);
        for (TaskExecution taskExecution : this.tasks.values()) {
            taskContext = taskExecution.getTaskContext();
            temp.merge(taskContext.getOutputDataSize());
        }
        this.outputDataSize.resetTo(temp);
        temp = new CounterStat();
        temp.merge(this.finishedOutputPositions);
        for (TaskExecution taskExecution : this.tasks.values()) {
            taskContext = taskExecution.getTaskContext();
            temp.merge(taskContext.getOutputPositions());
        }
        this.outputPositions.resetTo(temp);
    }
}

