/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;

public class CreateViewTask
implements DataDefinitionTask<CreateView> {
    private final JsonCodec<ViewDefinition> codec;
    private final List<PlanOptimizer> planOptimizers;
    private final boolean experimentalSyntaxEnabled;

    @Inject
    public CreateViewTask(JsonCodec<ViewDefinition> codec, List<PlanOptimizer> planOptimizers, FeaturesConfig featuresConfig) {
        this.codec = (JsonCodec)Preconditions.checkNotNull(codec, (Object)"codec is null");
        this.planOptimizers = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(planOptimizers, (Object)"planOptimizers is null")));
        this.experimentalSyntaxEnabled = ((FeaturesConfig)Preconditions.checkNotNull((Object)featuresConfig, (Object)"featuresConfig is null")).isExperimentalSyntaxEnabled();
    }

    @Override
    public void execute(CreateView statement, ConnectorSession session, Metadata metadata) {
        QualifiedTableName name = MetadataUtil.createQualifiedTableName(session, statement.getName());
        String sql = CreateViewTask.getFormattedSql(statement);
        Analysis analysis = this.analyzeStatement((Statement)statement, session, metadata);
        Collection<Field> fields = analysis.getOutputDescriptor().getVisibleFields();
        ImmutableList columns = FluentIterable.from(fields).transform(CreateViewTask.fieldToColumn()).toList();
        String data = this.codec.toJson((Object)new ViewDefinition(sql, session.getCatalog(), session.getSchema(), (List<ViewDefinition.ViewColumn>)columns));
        metadata.createView(session, name, data, statement.isReplace());
    }

    public Analysis analyzeStatement(Statement statement, ConnectorSession session, Metadata metadata) {
        QueryExplainer explainer = new QueryExplainer(session, this.planOptimizers, metadata, this.experimentalSyntaxEnabled);
        Analyzer analyzer = new Analyzer(session, metadata, (Optional<QueryExplainer>)Optional.of((Object)explainer), this.experimentalSyntaxEnabled);
        return analyzer.analyze(statement);
    }

    private static Function<Field, ViewDefinition.ViewColumn> fieldToColumn() {
        return new Function<Field, ViewDefinition.ViewColumn>(){

            public ViewDefinition.ViewColumn apply(Field field) {
                return new ViewDefinition.ViewColumn((String)field.getName().get(), field.getType());
            }
        };
    }

    public static String getFormattedSql(CreateView statement) {
        Statement parsed;
        Query query = statement.getQuery();
        String sql = SqlFormatter.formatSql((Node)query);
        try {
            parsed = SqlParser.createStatement((String)sql);
        }
        catch (ParsingException e) {
            throw new PrestoException(StandardErrorCode.INTERNAL_ERROR.toErrorCode(), "Formatted query does not parse: " + query);
        }
        if (!query.equals((Object)parsed)) {
            throw new PrestoException(StandardErrorCode.INTERNAL_ERROR.toErrorCode(), "Query does not round-trip: " + query);
        }
        return sql;
    }
}

