/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.connector.system.SystemRecordSetProvider;
import com.facebook.presto.connector.system.SystemSplitManager;
import com.facebook.presto.connector.system.SystemTablesMetadata;
import com.facebook.presto.spi.SystemTable;
import java.util.Set;
import javax.inject.Inject;

public class SystemTablesManager {
    private final SystemTablesMetadata metadata;
    private final SystemSplitManager splitManager;
    private final SystemRecordSetProvider dataStreamProvider;

    @Inject
    public SystemTablesManager(SystemTablesMetadata metadata, SystemSplitManager splitManager, SystemRecordSetProvider dataStreamProvider, Set<SystemTable> tables) {
        this.metadata = metadata;
        this.splitManager = splitManager;
        this.dataStreamProvider = dataStreamProvider;
        for (SystemTable table : tables) {
            this.addTable(table);
        }
    }

    public void addTable(SystemTable systemTable) {
        this.metadata.addTable(systemTable.getTableMetadata());
        this.splitManager.addTable(systemTable);
        this.dataStreamProvider.addTable(systemTable);
    }
}

