/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode;

import com.facebook.presto.byteCode.AnnotationDefinition;
import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.Comment;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.LocalVariableDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.NamedParameterDefinition;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.control.CaseStatement;
import com.facebook.presto.byteCode.control.DoWhileLoop;
import com.facebook.presto.byteCode.control.ForLoop;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.byteCode.control.LookupSwitch;
import com.facebook.presto.byteCode.control.WhileLoop;
import com.facebook.presto.byteCode.debug.LineNumberNode;
import com.facebook.presto.byteCode.instruction.Constant;
import com.facebook.presto.byteCode.instruction.InstructionNode;
import com.facebook.presto.byteCode.instruction.InvokeInstruction;
import com.facebook.presto.byteCode.instruction.JumpInstruction;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.facebook.presto.byteCode.instruction.VariableInstruction;
import com.google.common.base.Joiner;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DumpByteCodeVisitor
extends ByteCodeVisitor<Void> {
    private final PrintStream out;
    private int indentLevel;
    private int lineNumber = -1;

    public DumpByteCodeVisitor(PrintStream out) {
        this.out = out;
    }

    @Override
    public Void visitClass(ClassDefinition classDefinition) {
        for (AnnotationDefinition annotationDefinition : classDefinition.getAnnotations()) {
            this.visitAnnotation(classDefinition, annotationDefinition);
        }
        Line classDeclaration = this.line().addAll(classDefinition.getAccess()).add("class").add(classDefinition.getType().getJavaClassName());
        if (!classDefinition.getSuperClass().equals(ParameterizedType.type(Object.class))) {
            classDeclaration.add("extends").add(classDefinition.getSuperClass().getJavaClassName());
        }
        if (!classDefinition.getInterfaces().isEmpty()) {
            classDeclaration.add("implements");
            for (ParameterizedType interfaceType : classDefinition.getInterfaces()) {
                classDeclaration.add(interfaceType.getJavaClassName());
            }
        }
        classDeclaration.print();
        this.printLine("{");
        ++this.indentLevel;
        for (FieldDefinition fieldDefinition : classDefinition.getFields()) {
            this.visitField(classDefinition, fieldDefinition);
        }
        for (MethodDefinition methodDefinition : classDefinition.getMethods()) {
            this.visitMethod(classDefinition, methodDefinition);
        }
        --this.indentLevel;
        this.printLine("}");
        this.printLine();
        return null;
    }

    @Override
    public Void visitAnnotation(Object parent, AnnotationDefinition annotationDefinition) {
        this.printLine("@%s", annotationDefinition.getType().getJavaClassName(), annotationDefinition.getValues());
        return null;
    }

    @Override
    public Void visitField(ClassDefinition classDefinition, FieldDefinition fieldDefinition) {
        for (AnnotationDefinition annotationDefinition : fieldDefinition.getAnnotations()) {
            this.visitAnnotation(fieldDefinition, annotationDefinition);
        }
        this.line().addAll((Collection<?>)fieldDefinition.getAccess()).add(fieldDefinition.getType().getJavaClassName()).add(fieldDefinition.getName()).add(";").print();
        this.printLine();
        return null;
    }

    @Override
    public Void visitMethod(ClassDefinition classDefinition, MethodDefinition methodDefinition) {
        if (methodDefinition.getComment() != null) {
            this.printLine("// %s", methodDefinition.getComment());
        }
        for (AnnotationDefinition annotationDefinition : methodDefinition.getAnnotations()) {
            this.visitAnnotation(methodDefinition, annotationDefinition);
        }
        Line methodDeclaration = this.line().addAll(methodDefinition.getAccess()).add(methodDefinition.getReturnType().getJavaClassName());
        if (!methodDefinition.getParameters().isEmpty()) {
            Line parameters = this.line(", ");
            for (NamedParameterDefinition parameterDefinition : methodDefinition.getParameters()) {
                parameters.add(this.line().add(parameterDefinition.getType().getJavaClassName()).add(parameterDefinition.getName()));
            }
            methodDeclaration.add(methodDefinition.getName() + "(" + parameters + ")");
        } else {
            methodDeclaration.add(methodDefinition.getName() + "()");
        }
        methodDeclaration.print();
        methodDefinition.getBody().accept(null, this);
        this.printLine();
        return null;
    }

    @Override
    public Void visitComment(ByteCodeNode parent, Comment node) {
        this.printLine();
        this.printLine("// %s", node.getComment());
        return null;
    }

    @Override
    public Void visitBlock(ByteCodeNode parent, Block block) {
        if (block.getDescription() != null) {
            this.line().add(block.getDescription()).add("{").print();
        } else {
            this.printLine("{");
        }
        ++this.indentLevel;
        this.visitBlockContents(block);
        --this.indentLevel;
        this.printLine("}");
        return null;
    }

    private void visitBlockContents(Block block) {
        for (ByteCodeNode node : block.getChildNodes()) {
            if (node instanceof Block) {
                Block childBlock = (Block)node;
                if (childBlock.getDescription() != null) {
                    this.visitBlock(block, childBlock);
                    continue;
                }
                this.visitBlockContents(childBlock);
                continue;
            }
            node.accept(node, this);
        }
    }

    @Override
    public Void visitNode(ByteCodeNode parent, ByteCodeNode node) {
        this.printLine(node.toString());
        super.visitNode(parent, node);
        return null;
    }

    @Override
    public Void visitLabel(ByteCodeNode parent, LabelNode labelNode) {
        this.printLine("%s:", labelNode.getName());
        return null;
    }

    @Override
    public Void visitJumpInstruction(ByteCodeNode parent, JumpInstruction jumpInstruction) {
        this.printLine("%s %s", jumpInstruction.getOpCode(), jumpInstruction.getLabel().getName());
        return null;
    }

    @Override
    public Void visitLoadVariable(ByteCodeNode parent, VariableInstruction.LoadVariableInstruction loadVariableInstruction) {
        LocalVariableDefinition variable = loadVariableInstruction.getVariable();
        this.printLine("load %s(#%d)", variable.getName(), variable.getSlot());
        return null;
    }

    @Override
    public Void visitStoreVariable(ByteCodeNode parent, VariableInstruction.StoreVariableInstruction storeVariableInstruction) {
        LocalVariableDefinition variable = storeVariableInstruction.getVariable();
        this.printLine("store %s(#%d)", variable.getName(), variable.getSlot());
        return null;
    }

    @Override
    public Void visitIncrementVariable(ByteCodeNode parent, VariableInstruction.IncrementVariableInstruction incrementVariableInstruction) {
        LocalVariableDefinition variable = incrementVariableInstruction.getVariable();
        byte increment = incrementVariableInstruction.getIncrement();
        this.printLine("increment %s(#%d) %s", variable.getName(), variable.getSlot(), increment);
        return null;
    }

    @Override
    public Void visitInvoke(ByteCodeNode parent, InvokeInstruction invokeInstruction) {
        this.printLine("invoke %s.%s%s", invokeInstruction.getTarget().getJavaClassName(), invokeInstruction.getName(), invokeInstruction.getMethodDescription());
        return null;
    }

    @Override
    public Void visitInvokeDynamic(ByteCodeNode parent, InvokeInstruction.InvokeDynamicInstruction invokeDynamicInstruction) {
        this.printLine("invokeDynamic %s%s %s", invokeDynamicInstruction.getName(), invokeDynamicInstruction.getMethodDescription(), invokeDynamicInstruction.getBootstrapArguments());
        return null;
    }

    @Override
    public Void visitIf(ByteCodeNode parent, IfStatement ifStatement) {
        if (ifStatement.getComment() != null) {
            this.printLine();
            this.printLine("// %s", ifStatement.getComment());
        }
        this.printLine("if {");
        ++this.indentLevel;
        ifStatement.getCondition().accept(ifStatement, this);
        ifStatement.getIfTrue().accept(ifStatement, this);
        if (ifStatement.getIfFalse() != null) {
            ifStatement.getIfFalse().accept(ifStatement, this);
        }
        --this.indentLevel;
        this.printLine("}");
        return null;
    }

    @Override
    public Void visitFor(ByteCodeNode parent, ForLoop forLoop) {
        if (forLoop.getComment() != null) {
            this.printLine();
            this.printLine("// %s", forLoop.getComment());
        }
        this.printLine("for {");
        ++this.indentLevel;
        forLoop.getInitialize().accept(forLoop, this);
        forLoop.getCondition().accept(forLoop, this);
        forLoop.getUpdate().accept(forLoop, this);
        forLoop.getBody().accept(forLoop, this);
        --this.indentLevel;
        this.printLine("}");
        return null;
    }

    @Override
    public Void visitWhile(ByteCodeNode parent, WhileLoop whileLoop) {
        if (whileLoop.getComment() != null) {
            this.printLine();
            this.printLine("// %s", whileLoop.getComment());
        }
        this.printLine("while {");
        ++this.indentLevel;
        whileLoop.getCondition().accept(whileLoop, this);
        whileLoop.getBody().accept(whileLoop, this);
        --this.indentLevel;
        this.printLine("}");
        return null;
    }

    @Override
    public Void visitDoWhile(ByteCodeNode parent, DoWhileLoop doWhileLoop) {
        if (doWhileLoop.getComment() != null) {
            this.printLine();
            this.printLine("// %s", doWhileLoop.getComment());
        }
        return (Void)super.visitDoWhile(parent, doWhileLoop);
    }

    @Override
    public Void visitLookupSwitch(ByteCodeNode parent, LookupSwitch lookupSwitch) {
        if (lookupSwitch.getComment() != null) {
            this.printLine();
            this.printLine("// %s", lookupSwitch.getComment());
        }
        this.printLine("switch {");
        ++this.indentLevel;
        for (CaseStatement caseStatement : lookupSwitch.getCases()) {
            this.printLine("case %s: goto %s", caseStatement.getKey(), caseStatement.getLabel().getName());
        }
        this.printLine("default: goto %s", lookupSwitch.getDefaultCase().getName());
        --this.indentLevel;
        this.printLine("}");
        return null;
    }

    @Override
    public Void visitInstruction(ByteCodeNode parent, InstructionNode node) {
        return (Void)super.visitInstruction(parent, node);
    }

    @Override
    public Void visitBoxedBooleanConstant(ByteCodeNode parent, Constant.BoxedBooleanConstant boxedBooleanConstant) {
        this.printLine("load constant %s", boxedBooleanConstant.getValue());
        return null;
    }

    @Override
    public Void visitIntConstant(ByteCodeNode parent, Constant.IntConstant intConstant) {
        this.printLine("load constant %s", intConstant.getValue());
        return null;
    }

    @Override
    public Void visitBoxedIntegerConstant(ByteCodeNode parent, Constant.BoxedIntegerConstant boxedIntegerConstant) {
        this.printLine("load constant new Integer(%s)", boxedIntegerConstant.getValue());
        return null;
    }

    @Override
    public Void visitFloatConstant(ByteCodeNode parent, Constant.FloatConstant floatConstant) {
        this.printLine("load constant %sf", floatConstant.getValue());
        return null;
    }

    @Override
    public Void visitBoxedFloatConstant(ByteCodeNode parent, Constant.BoxedFloatConstant boxedFloatConstant) {
        this.printLine("load constant new Float(%sf)", boxedFloatConstant.getValue());
        return null;
    }

    @Override
    public Void visitLongConstant(ByteCodeNode parent, Constant.LongConstant longConstant) {
        this.printLine("load constant %sL", longConstant.getValue());
        return null;
    }

    @Override
    public Void visitBoxedLongConstant(ByteCodeNode parent, Constant.BoxedLongConstant boxedLongConstant) {
        this.printLine("load constant new Long(%sL)", boxedLongConstant.getValue());
        return null;
    }

    @Override
    public Void visitDoubleConstant(ByteCodeNode parent, Constant.DoubleConstant doubleConstant) {
        this.printLine("load constant %s", doubleConstant.getValue());
        return null;
    }

    @Override
    public Void visitBoxedDoubleConstant(ByteCodeNode parent, Constant.BoxedDoubleConstant boxedDoubleConstant) {
        this.printLine("load constant new Double(%s)", boxedDoubleConstant.getValue());
        return null;
    }

    @Override
    public Void visitStringConstant(ByteCodeNode parent, Constant.StringConstant stringConstant) {
        this.printLine("load constant \"%s\"", stringConstant.getValue());
        return null;
    }

    @Override
    public Void visitClassConstant(ByteCodeNode parent, Constant.ClassConstant classConstant) {
        this.printLine("load constant %s.class", classConstant.getValue().getJavaClassName());
        return null;
    }

    @Override
    public Void visitLineNumber(ByteCodeNode parent, LineNumberNode lineNumberNode) {
        this.lineNumber = lineNumberNode.getLineNumber();
        this.printLine("LINE %s", this.lineNumber);
        return null;
    }

    public void printLine() {
        this.out.println(this.indent(this.indentLevel));
    }

    public void printLine(String line) {
        this.out.println(String.format("%s%s", this.indent(this.indentLevel), line));
    }

    public void printLine(String format, Object ... args) {
        String line = String.format(format, args);
        this.out.println(String.format("%s%s", this.indent(this.indentLevel), line));
    }

    public void printWords(String ... words) {
        String line = Joiner.on((String)" ").join((Object[])words);
        this.out.println(String.format("%s%s", this.indent(this.indentLevel), line));
    }

    private String indent(int level) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            builder.append("    ");
        }
        return builder.toString();
    }

    private Line line() {
        return new Line();
    }

    private Line line(String separator) {
        return new Line(separator);
    }

    private class Line {
        private final String separator;
        private final List<Object> parts = new ArrayList<Object>();

        private Line() {
            this.separator = " ";
        }

        private Line(String separator) {
            this.separator = separator;
        }

        public Line add(Object element) {
            this.parts.add(element);
            return this;
        }

        public Line addAll(Collection<?> c) {
            this.parts.addAll(c);
            return this;
        }

        public void print() {
            DumpByteCodeVisitor.this.printLine(Joiner.on((String)this.separator).join(this.parts));
        }

        public String toString() {
            return Joiner.on((String)this.separator).join(this.parts);
        }
    }
}

