/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.rle;

import com.facebook.presto.block.rle.RunLengthEncodedBlock;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;

public final class RunLengthEncodedBlockCursor
implements BlockCursor {
    private final Block value;
    private final int positionCount;
    private int position = -1;

    public RunLengthEncodedBlockCursor(Block value, int positionCount) {
        this.value = (Block)Preconditions.checkNotNull((Object)value, (Object)"value is null");
        Preconditions.checkArgument((value.getPositionCount() == 1 ? 1 : 0) != 0, (String)"Expected value to contain a single position but has %s positions", (Object[])new Object[]{value.getPositionCount()});
        Preconditions.checkArgument((positionCount >= 0 ? 1 : 0) != 0, (Object)"positionCount is negative");
        this.positionCount = positionCount;
        this.position = -1;
    }

    public RunLengthEncodedBlockCursor(RunLengthEncodedBlockCursor cursor) {
        this.value = cursor.value;
        this.positionCount = cursor.positionCount;
        this.position = cursor.position;
    }

    public BlockCursor duplicate() {
        return new RunLengthEncodedBlockCursor(this);
    }

    public Type getType() {
        return this.value.getType();
    }

    public int getRemainingPositions() {
        return this.positionCount - (this.position + 1);
    }

    public boolean isValid() {
        return 0 <= this.position && this.position < this.positionCount;
    }

    public boolean isFinished() {
        return this.position >= this.positionCount;
    }

    private void checkReadablePosition() {
        Preconditions.checkState((boolean)this.isValid(), (Object)"cursor is not valid");
    }

    public boolean advanceNextPosition() {
        if (this.position >= this.positionCount - 1) {
            this.position = this.positionCount;
            return false;
        }
        ++this.position;
        return true;
    }

    public boolean advanceToPosition(int newPosition) {
        if (newPosition >= this.positionCount) {
            this.position = this.positionCount;
            return false;
        }
        Preconditions.checkArgument((newPosition >= this.position ? 1 : 0) != 0, (Object)"Can't advance backwards");
        this.position = newPosition;
        return true;
    }

    public Block getRegionAndAdvance(int length) {
        length = Math.min(length, this.getRemainingPositions());
        this.position += length;
        return new RunLengthEncodedBlock(this.value, length);
    }

    public Block getSingleValueBlock() {
        this.checkReadablePosition();
        return this.value;
    }

    public boolean getBoolean() {
        this.checkReadablePosition();
        return this.value.getBoolean(0);
    }

    public long getLong() {
        this.checkReadablePosition();
        return this.value.getLong(0);
    }

    public double getDouble() {
        this.checkReadablePosition();
        return this.value.getDouble(0);
    }

    public Slice getSlice() {
        this.checkReadablePosition();
        return this.value.getSlice(0);
    }

    public Object getObjectValue(ConnectorSession session) {
        this.checkReadablePosition();
        return this.value.getObjectValue(session, 0);
    }

    public boolean isNull() {
        this.checkReadablePosition();
        return this.value.isNull(0);
    }

    public int getPosition() {
        this.checkReadablePosition();
        return this.position;
    }

    public int compareTo(Slice otherSlice, int otherOffset) {
        this.checkReadablePosition();
        return this.value.compareTo(0, otherSlice, otherOffset);
    }

    public int hash() {
        return this.value.hash(0);
    }

    public void appendTo(BlockBuilder blockBuilder) {
        this.value.appendTo(0, blockBuilder);
    }
}

