/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.rle;

import com.facebook.presto.block.rle.RunLengthBlockEncoding;
import com.facebook.presto.block.rle.RunLengthEncodedBlockCursor;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;

public class RunLengthEncodedBlock
implements Block {
    private final Block value;
    private final int positionCount;

    public RunLengthEncodedBlock(Block value, int positionCount) {
        this.value = (Block)Preconditions.checkNotNull((Object)value, (Object)"value is null");
        Preconditions.checkArgument((value.getPositionCount() == 1 ? 1 : 0) != 0, (String)"Expected value to contain a single position but has %s positions", (Object[])new Object[]{value.getPositionCount()});
        Preconditions.checkArgument((!(value instanceof RunLengthEncodedBlock) ? 1 : 0) != 0, (String)"Value can not be an instance of a %s", (Object[])new Object[]{this.getClass().getName()});
        Preconditions.checkArgument((positionCount >= 0 ? 1 : 0) != 0, (Object)"positionCount is negative");
        this.positionCount = (Integer)Preconditions.checkNotNull((Object)positionCount, (Object)"positionCount is null");
    }

    public Block getValue() {
        return this.value;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public int getSizeInBytes() {
        return this.value.getSizeInBytes();
    }

    public RunLengthBlockEncoding getEncoding() {
        return new RunLengthBlockEncoding(this.value.getEncoding());
    }

    public Block getRegion(int positionOffset, int length) {
        Preconditions.checkPositionIndexes((int)positionOffset, (int)(positionOffset + length), (int)this.positionCount);
        return new RunLengthEncodedBlock(this.value, length);
    }

    public Type getType() {
        return this.value.getType();
    }

    public boolean getBoolean(int position) {
        this.checkReadablePosition(position);
        return this.value.getBoolean(0);
    }

    public long getLong(int position) {
        this.checkReadablePosition(position);
        return this.value.getLong(0);
    }

    public double getDouble(int position) {
        this.checkReadablePosition(position);
        return this.value.getDouble(0);
    }

    public Object getObjectValue(ConnectorSession session, int position) {
        this.checkReadablePosition(position);
        return this.value.getObjectValue(session, 0);
    }

    public Slice getSlice(int position) {
        this.checkReadablePosition(position);
        return this.value.getSlice(0);
    }

    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        return this.value;
    }

    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.value.isNull(0);
    }

    public boolean equalTo(int position, Block otherBlock, int otherPosition) {
        this.checkReadablePosition(position);
        return this.value.equalTo(0, otherBlock, otherPosition);
    }

    public boolean equalTo(int position, BlockCursor cursor) {
        this.checkReadablePosition(position);
        return this.value.equalTo(0, cursor);
    }

    public boolean equalTo(int position, Slice otherSlice, int otherOffset) {
        this.checkReadablePosition(position);
        return this.value.equalTo(0, otherSlice, otherOffset);
    }

    public int hash(int position) {
        this.checkReadablePosition(position);
        return this.value.hash(0);
    }

    public int compareTo(SortOrder sortOrder, int position, Block otherBlock, int otherPosition) {
        this.checkReadablePosition(position);
        return this.value.compareTo(sortOrder, 0, otherBlock, otherPosition);
    }

    public int compareTo(SortOrder sortOrder, int position, BlockCursor cursor) {
        this.checkReadablePosition(position);
        return this.value.compareTo(sortOrder, 0, cursor);
    }

    public int compareTo(int position, Slice otherSlice, int otherOffset) {
        this.checkReadablePosition(position);
        return this.value.compareTo(0, otherSlice, otherOffset);
    }

    public void appendTo(int position, BlockBuilder blockBuilder) {
        this.value.appendTo(0, blockBuilder);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("value", (Object)this.value).add("positionCount", this.positionCount).toString();
    }

    public RunLengthEncodedBlockCursor cursor() {
        return new RunLengthEncodedBlockCursor(this.value, this.positionCount);
    }

    private void checkReadablePosition(int position) {
        Preconditions.checkState((position >= 0 && position < this.positionCount ? 1 : 0) != 0, (Object)"position is not valid");
    }
}

