/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.dictionary;

import com.facebook.presto.block.dictionary.DictionaryEncodedBlock;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;

public class DictionaryEncodedBlockCursor
implements BlockCursor {
    private final Block dictionary;
    private final BlockCursor idCursor;

    public DictionaryEncodedBlockCursor(Block dictionary, BlockCursor idCursor) {
        this.dictionary = (Block)Preconditions.checkNotNull((Object)dictionary, (Object)"dictionary is null");
        this.idCursor = (BlockCursor)Preconditions.checkNotNull((Object)idCursor, (Object)"idCursor is null");
        Preconditions.checkArgument((boolean)idCursor.getType().equals(BigintType.BIGINT), (String)"Expected bigint cursor but got %s cursor", (Object[])new Object[]{idCursor.getType()});
    }

    public DictionaryEncodedBlockCursor(DictionaryEncodedBlockCursor cursor) {
        this.dictionary = cursor.dictionary;
        this.idCursor = cursor.idCursor.duplicate();
    }

    public BlockCursor duplicate() {
        return new DictionaryEncodedBlockCursor(this);
    }

    public Type getType() {
        return this.dictionary.getType();
    }

    public int getRemainingPositions() {
        return this.idCursor.getRemainingPositions();
    }

    public boolean isValid() {
        return this.idCursor.isValid();
    }

    public boolean isFinished() {
        return this.idCursor.isFinished();
    }

    public boolean advanceNextPosition() {
        return this.idCursor.advanceNextPosition();
    }

    public boolean advanceToPosition(int position) {
        return this.idCursor.advanceToPosition(position);
    }

    public Block getRegionAndAdvance(int length) {
        return new DictionaryEncodedBlock(this.dictionary, this.idCursor.getRegionAndAdvance(length));
    }

    public Block getSingleValueBlock() {
        return this.dictionary.getSingleValueBlock(this.getDictionaryKey());
    }

    public boolean getBoolean() {
        return this.dictionary.getBoolean(this.getDictionaryKey());
    }

    public long getLong() {
        return this.dictionary.getLong(this.getDictionaryKey());
    }

    public double getDouble() {
        return this.dictionary.getDouble(this.getDictionaryKey());
    }

    public Slice getSlice() {
        return this.dictionary.getSlice(this.getDictionaryKey());
    }

    public Object getObjectValue(ConnectorSession session) {
        return this.dictionary.getObjectValue(session, this.getDictionaryKey());
    }

    public boolean isNull() {
        return this.dictionary.isNull(this.getDictionaryKey());
    }

    public int getPosition() {
        return this.idCursor.getPosition();
    }

    public int compareTo(Slice otherSlice, int otherOffset) {
        return this.dictionary.compareTo(this.getDictionaryKey(), otherSlice, otherOffset);
    }

    public int hash() {
        return this.dictionary.hash(this.getDictionaryKey());
    }

    public void appendTo(BlockBuilder blockBuilder) {
        this.dictionary.appendTo(this.getDictionaryKey(), blockBuilder);
    }

    public int getDictionaryKey() {
        int dictionaryKey = Ints.checkedCast((long)this.idCursor.getLong());
        Preconditions.checkPositionIndex((int)dictionaryKey, (int)this.dictionary.getPositionCount(), (String)"dictionaryKey does not exist");
        return dictionaryKey;
    }
}

