/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.dictionary;

import com.facebook.presto.block.dictionary.DictionaryBlockEncoding;
import com.facebook.presto.block.dictionary.DictionaryEncodedBlockCursor;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockCursor;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;

public class DictionaryEncodedBlock
implements Block {
    private final Block dictionary;
    private final Block idBlock;

    public DictionaryEncodedBlock(Block dictionary, Block idBlock) {
        this.dictionary = (Block)Preconditions.checkNotNull((Object)dictionary, (Object)"dictionary is null");
        this.idBlock = (Block)Preconditions.checkNotNull((Object)idBlock, (Object)"idBlock is null");
        Preconditions.checkArgument((boolean)idBlock.getType().equals(BigintType.BIGINT), (String)"Expected bigint block but got %s block", (Object[])new Object[]{idBlock.getType()});
    }

    public Type getType() {
        return this.dictionary.getType();
    }

    public Block getDictionary() {
        return this.dictionary;
    }

    public Block getIdBlock() {
        return this.idBlock;
    }

    public int getPositionCount() {
        return this.idBlock.getPositionCount();
    }

    public int getSizeInBytes() {
        return Ints.checkedCast((long)(this.dictionary.getSizeInBytes() + this.idBlock.getSizeInBytes()));
    }

    public BlockEncoding getEncoding() {
        return new DictionaryBlockEncoding(this.dictionary, this.idBlock.getEncoding());
    }

    public Block getRegion(int positionOffset, int length) {
        return new DictionaryEncodedBlock(this.dictionary, this.idBlock.getRegion(positionOffset, length));
    }

    public DictionaryEncodedBlockCursor cursor() {
        return new DictionaryEncodedBlockCursor(this.dictionary, this.idBlock.cursor());
    }

    public boolean getBoolean(int position) {
        return this.dictionary.getBoolean(this.getDictionaryKey(position));
    }

    public long getLong(int position) {
        return this.dictionary.getLong(this.getDictionaryKey(position));
    }

    public double getDouble(int position) {
        return this.dictionary.getDouble(this.getDictionaryKey(position));
    }

    public Slice getSlice(int position) {
        return this.dictionary.getSlice(this.getDictionaryKey(position));
    }

    public Block getSingleValueBlock(int position) {
        return this.dictionary.getSingleValueBlock(this.getDictionaryKey(position));
    }

    public Object getObjectValue(ConnectorSession session, int position) {
        return this.dictionary.getObjectValue(session, this.getDictionaryKey(position));
    }

    public boolean isNull(int position) {
        return this.dictionary.isNull(this.getDictionaryKey(position));
    }

    public boolean equalTo(int position, Block otherBlock, int otherPosition) {
        return this.dictionary.equalTo(this.getDictionaryKey(position), otherBlock, otherPosition);
    }

    public boolean equalTo(int position, BlockCursor value) {
        return this.dictionary.equalTo(this.getDictionaryKey(position), value);
    }

    public boolean equalTo(int position, Slice otherSlice, int otherOffset) {
        return this.dictionary.equalTo(this.getDictionaryKey(position), otherSlice, otherOffset);
    }

    public int hash(int position) {
        return this.dictionary.hash(this.getDictionaryKey(position));
    }

    public int compareTo(SortOrder sortOrder, int position, Block otherBlock, int otherPosition) {
        return this.dictionary.compareTo(sortOrder, this.getDictionaryKey(position), otherBlock, otherPosition);
    }

    public int compareTo(SortOrder sortOrder, int position, BlockCursor cursor) {
        return this.dictionary.compareTo(sortOrder, this.getDictionaryKey(position), cursor);
    }

    public int compareTo(int position, Slice otherSlice, int otherOffset) {
        return this.dictionary.compareTo(this.getDictionaryKey(position), otherSlice, otherOffset);
    }

    public void appendTo(int position, BlockBuilder blockBuilder) {
        this.dictionary.appendTo(this.getDictionaryKey(position), blockBuilder);
    }

    private int getDictionaryKey(int position) {
        return Ints.checkedCast((long)this.idBlock.getLong(position));
    }
}

