/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.dictionary;

import com.facebook.presto.block.dictionary.DictionaryEncodedBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public class DictionaryBlockEncoding
implements BlockEncoding {
    public static final BlockEncodingFactory<DictionaryBlockEncoding> FACTORY = new DictionaryBlockEncodingFactory();
    private static final String NAME = "DIC";
    private final Block dictionary;
    private final BlockEncoding idBlockEncoding;

    public DictionaryBlockEncoding(Block dictionary, BlockEncoding idBlockEncoding) {
        this.dictionary = (Block)Preconditions.checkNotNull((Object)dictionary, (Object)"dictionary is null");
        this.idBlockEncoding = (BlockEncoding)Preconditions.checkNotNull((Object)idBlockEncoding, (Object)"idBlockEncoding is null");
    }

    public String getName() {
        return NAME;
    }

    public Type getType() {
        return this.dictionary.getType();
    }

    public void writeBlock(SliceOutput sliceOutput, Block block) {
        DictionaryEncodedBlock dictionaryBlock = (DictionaryEncodedBlock)block;
        Preconditions.checkArgument((dictionaryBlock.getDictionary() == this.dictionary ? 1 : 0) != 0, (Object)"Block dictionary is not the same a this dictionary");
        this.idBlockEncoding.writeBlock(sliceOutput, dictionaryBlock.getIdBlock());
    }

    public Block readBlock(SliceInput sliceInput) {
        Block idBlock = this.idBlockEncoding.readBlock(sliceInput);
        return new DictionaryEncodedBlock(this.dictionary, idBlock);
    }

    private static class DictionaryBlockEncodingFactory
    implements BlockEncodingFactory<DictionaryBlockEncoding> {
        private DictionaryBlockEncodingFactory() {
        }

        public String getName() {
            return DictionaryBlockEncoding.NAME;
        }

        public DictionaryBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            BlockEncoding dictionaryEncoding = serde.readBlockEncoding(input);
            Block dictionary = dictionaryEncoding.readBlock(input);
            BlockEncoding idBlockEncoding = serde.readBlockEncoding(input);
            return new DictionaryBlockEncoding(dictionary, idBlockEncoding);
        }

        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, DictionaryBlockEncoding blockEncoding) {
            BlockEncoding dictionaryBlockEncoding = blockEncoding.dictionary.getEncoding();
            serde.writeBlockEncoding(output, dictionaryBlockEncoding);
            dictionaryBlockEncoding.writeBlock(output, blockEncoding.dictionary);
            serde.writeBlockEncoding(output, blockEncoding.idBlockEncoding);
        }
    }
}

