/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.BlockIterable;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.util.Iterator;

public final class BlockUtils {
    private BlockUtils() {
    }

    public static void appendObject(BlockBuilder blockBuilder, Object value) {
        if (value == null) {
            blockBuilder.appendNull();
        } else if (value instanceof Boolean) {
            blockBuilder.appendBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof Double || value instanceof Float) {
            blockBuilder.appendDouble(((Number)value).doubleValue());
        } else if (value instanceof Number) {
            blockBuilder.appendLong(((Number)value).longValue());
        } else if (value instanceof byte[]) {
            blockBuilder.appendSlice(Slices.wrappedBuffer((byte[])((byte[])value)));
        } else if (value instanceof String) {
            blockBuilder.appendSlice(Slices.utf8Slice((String)((String)value)));
        } else if (value instanceof Slice) {
            blockBuilder.appendSlice((Slice)value);
        } else {
            throw new IllegalArgumentException("Unsupported type: " + value.getClass().getName());
        }
    }

    public static BlockIterable emptyBlockIterable() {
        return new BlockIterable(){

            @Override
            public Type getType() {
                return BigintType.BIGINT;
            }

            @Override
            public Optional<DataSize> getDataSize() {
                return Optional.of((Object)new DataSize(0.0, DataSize.Unit.BYTE));
            }

            @Override
            public Optional<Integer> getPositionCount() {
                return Optional.of((Object)0);
            }

            @Override
            public Iterator<Block> iterator() {
                return Iterators.emptyIterator();
            }
        };
    }

    public static BlockIterable toBlocks(Iterable<Block> blocks) {
        return new BlocksIterableAdapter(((Block)Iterables.get(blocks, (int)0)).getType(), (Optional<DataSize>)Optional.absent(), (Optional<Integer>)Optional.absent(), blocks);
    }

    private static class BlocksIterableAdapter
    implements BlockIterable {
        private final Type type;
        private final Iterable<Block> blocks;
        private Optional<DataSize> dataSize;
        private final Optional<Integer> positionCount;

        public BlocksIterableAdapter(Type type, Optional<DataSize> dataSize, Optional<Integer> positionCount, Iterable<Block> blocks) {
            this.type = type;
            this.blocks = blocks;
            this.dataSize = dataSize;
            this.positionCount = positionCount;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public Optional<DataSize> getDataSize() {
            return this.dataSize;
        }

        @Override
        public Optional<Integer> getPositionCount() {
            return this.positionCount;
        }

        @Override
        public Iterator<Block> iterator() {
            return this.blocks.iterator();
        }
    }
}

