/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.MaterializeSampleNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SinkNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class GraphvizPrinter {
    private static final Map<NodeType, String> NODE_COLORS = Maps.immutableEnumMap((Map)ImmutableMap.builder().put((Object)NodeType.EXCHANGE, (Object)"gold").put((Object)NodeType.AGGREGATE, (Object)"chartreuse3").put((Object)NodeType.FILTER, (Object)"yellow").put((Object)NodeType.PROJECT, (Object)"bisque").put((Object)NodeType.TOPN, (Object)"darksalmon").put((Object)NodeType.OUTPUT, (Object)"white").put((Object)NodeType.LIMIT, (Object)"gray83").put((Object)NodeType.TABLESCAN, (Object)"deepskyblue").put((Object)NodeType.VALUES, (Object)"deepskyblue").put((Object)NodeType.JOIN, (Object)"orange").put((Object)NodeType.SORT, (Object)"aliceblue").put((Object)NodeType.SINK, (Object)"indianred1").put((Object)NodeType.WINDOW, (Object)"darkolivegreen4").put((Object)NodeType.UNION, (Object)"turquoise4").put((Object)NodeType.MARK_DISTINCT, (Object)"violet").put((Object)NodeType.MATERIALIZE_SAMPLE, (Object)"hotpink").put((Object)NodeType.INDEX_SOURCE, (Object)"dodgerblue3").build());

    private GraphvizPrinter() {
    }

    public static String printLogical(List<PlanFragment> fragments) {
        ImmutableMap fragmentsById = Maps.uniqueIndex(fragments, (Function)new Function<PlanFragment, PlanFragmentId>(){

            public PlanFragmentId apply(PlanFragment input) {
                return input.getId();
            }
        });
        PlanNodeIdGenerator idGenerator = new PlanNodeIdGenerator();
        StringBuilder output = new StringBuilder();
        output.append("digraph logical_plan {\n");
        for (PlanFragment fragment : fragments) {
            GraphvizPrinter.printFragmentNodes(output, fragment, idGenerator);
        }
        for (PlanFragment fragment : fragments) {
            fragment.getRoot().accept(new EdgePrinter(output, (Map<PlanFragmentId, PlanFragment>)fragmentsById, idGenerator), null);
        }
        output.append("}\n");
        return output.toString();
    }

    public static String printDistributed(SubPlan plan) {
        List<PlanFragment> fragments = plan.getAllFragments();
        ImmutableMap fragmentsById = Maps.uniqueIndex(fragments, PlanFragment.idGetter());
        PlanNodeIdGenerator idGenerator = new PlanNodeIdGenerator();
        StringBuilder output = new StringBuilder();
        output.append("digraph distributed_plan {\n");
        GraphvizPrinter.printSubPlan(plan, (Map<PlanFragmentId, PlanFragment>)fragmentsById, idGenerator, output);
        output.append("}\n");
        return output.toString();
    }

    private static void printSubPlan(SubPlan plan, Map<PlanFragmentId, PlanFragment> fragmentsById, PlanNodeIdGenerator idGenerator, StringBuilder output) {
        PlanFragment fragment = plan.getFragment();
        GraphvizPrinter.printFragmentNodes(output, fragment, idGenerator);
        fragment.getRoot().accept(new EdgePrinter(output, fragmentsById, idGenerator), null);
        for (SubPlan child : plan.getChildren()) {
            GraphvizPrinter.printSubPlan(child, fragmentsById, idGenerator, output);
        }
    }

    private static void printFragmentNodes(StringBuilder output, PlanFragment fragment, PlanNodeIdGenerator idGenerator) {
        String clusterId = "cluster_" + fragment.getId();
        output.append("subgraph ").append(clusterId).append(" {").append('\n');
        output.append(String.format("label = \"%s\"", new Object[]{fragment.getDistribution()})).append('\n');
        PlanNode plan = fragment.getRoot();
        plan.accept(new NodePrinter(output, idGenerator), null);
        output.append("}").append('\n');
    }

    static {
        Preconditions.checkState((NODE_COLORS.size() == NodeType.values().length ? 1 : 0) != 0);
    }

    private static class PlanNodeIdGenerator {
        private final Map<PlanNode, Integer> planNodeIds = new HashMap<PlanNode, Integer>();
        private int idCount = 0;

        public String getNodeId(PlanNode from) {
            int nodeId;
            if (this.planNodeIds.containsKey(from)) {
                nodeId = this.planNodeIds.get(from);
            } else {
                ++this.idCount;
                this.planNodeIds.put(from, this.idCount);
                nodeId = this.idCount;
            }
            return "plannode_" + nodeId;
        }
    }

    private static class EdgePrinter
    extends PlanVisitor<Void, Void> {
        private final StringBuilder output;
        private final Map<PlanFragmentId, PlanFragment> fragmentsById;
        private final PlanNodeIdGenerator idGenerator;

        public EdgePrinter(StringBuilder output, Map<PlanFragmentId, PlanFragment> fragmentsById, PlanNodeIdGenerator idGenerator) {
            this.output = output;
            this.fragmentsById = ImmutableMap.copyOf(fragmentsById);
            this.idGenerator = idGenerator;
        }

        @Override
        protected Void visitPlan(PlanNode node, Void context) {
            for (PlanNode child : node.getSources()) {
                this.printEdge(node, child);
                child.accept(this, context);
            }
            return null;
        }

        @Override
        public Void visitExchange(ExchangeNode node, Void context) {
            for (PlanFragmentId planFragmentId : node.getSourceFragmentIds()) {
                PlanFragment target = this.fragmentsById.get(planFragmentId);
                this.printEdge(node, target.getRoot());
            }
            return null;
        }

        private void printEdge(PlanNode from, PlanNode to) {
            String fromId = this.idGenerator.getNodeId(from);
            String toId = this.idGenerator.getNodeId(to);
            this.output.append(fromId).append(" -> ").append(toId).append(';').append('\n');
        }
    }

    private static class NodePrinter
    extends PlanVisitor<Void, Void> {
        private static final int MAX_NAME_WIDTH = 100;
        private final StringBuilder output;
        private PlanNodeIdGenerator idGenerator;

        public NodePrinter(StringBuilder output, PlanNodeIdGenerator idGenerator) {
            this.output = output;
            this.idGenerator = idGenerator;
        }

        @Override
        protected Void visitPlan(PlanNode node, Void context) {
            throw new UnsupportedOperationException(String.format("Node %s does not have a Graphviz visitor", node.getClass().getName()));
        }

        @Override
        public Void visitMaterializeSample(MaterializeSampleNode node, Void context) {
            this.printNode(node, String.format("MaterializeSample[%s]", node.getSampleWeightSymbol()), (String)NODE_COLORS.get((Object)NodeType.MATERIALIZE_SAMPLE));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitSort(SortNode node, Void context) {
            this.printNode(node, String.format("Sort[%s]", Joiner.on((String)", ").join(node.getOrderBy())), (String)NODE_COLORS.get((Object)NodeType.SORT));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitMarkDistinct(MarkDistinctNode node, Void context) {
            this.printNode(node, String.format("MarkDistinct[%s]", node.getMarkerSymbol()), String.format("%s => %s", node.getDistinctSymbols(), node.getMarkerSymbol()), (String)NODE_COLORS.get((Object)NodeType.MARK_DISTINCT));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitSink(SinkNode node, Void context) {
            this.printNode(node, "Sink", (String)NODE_COLORS.get((Object)NodeType.SINK));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitWindow(WindowNode node, Void context) {
            this.printNode(node, "Window", String.format("partition by = %s|order by = %s", Joiner.on((String)", ").join(node.getPartitionBy()), Joiner.on((String)", ").join(node.getOrderBy())), (String)NODE_COLORS.get((Object)NodeType.WINDOW));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitUnion(UnionNode node, Void context) {
            this.printNode(node, "Union", (String)NODE_COLORS.get((Object)NodeType.UNION));
            for (PlanNode planNode : node.getSources()) {
                planNode.accept(this, context);
            }
            return null;
        }

        @Override
        public Void visitExchange(ExchangeNode node, Void context) {
            this.printNode(node, "Exchange 1:N", (String)NODE_COLORS.get((Object)NodeType.EXCHANGE));
            return null;
        }

        @Override
        public Void visitAggregation(AggregationNode node, Void context) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                if (node.getMasks().containsKey(entry.getKey())) {
                    builder.append(String.format("%s := %s (mask = %s)\\n", entry.getKey(), entry.getValue(), node.getMasks().get(entry.getKey())));
                    continue;
                }
                builder.append(String.format("%s := %s\\n", entry.getKey(), entry.getValue()));
            }
            this.printNode(node, String.format("Aggregate[%s]", new Object[]{node.getStep()}), builder.toString(), (String)NODE_COLORS.get((Object)NodeType.AGGREGATE));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitFilter(FilterNode node, Void context) {
            String expression = node.getPredicate().toString();
            this.printNode(node, "Filter", expression, (String)NODE_COLORS.get((Object)NodeType.FILTER));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitProject(ProjectNode node, Void context) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<Symbol, Expression> entry : node.getOutputMap().entrySet()) {
                if (entry.getValue() instanceof QualifiedNameReference && ((QualifiedNameReference)entry.getValue()).getName().equals((Object)entry.getKey().toQualifiedName())) continue;
                builder.append(String.format("%s := %s\\n", entry.getKey(), entry.getValue()));
            }
            this.printNode(node, "Project", builder.toString(), (String)NODE_COLORS.get((Object)NodeType.PROJECT));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitTopN(final TopNNode node, Void context) {
            Iterable keys = Iterables.transform(node.getOrderBy(), (Function)new Function<Symbol, String>(){

                public String apply(Symbol input) {
                    return input + " " + node.getOrderings().get(input);
                }
            });
            this.printNode(node, String.format("TopN[%s]", node.getCount()), Joiner.on((String)", ").join(keys), (String)NODE_COLORS.get((Object)NodeType.TOPN));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitOutput(OutputNode node, Void context) {
            String columns = this.getColumns(node);
            this.printNode(node, String.format("Output[%s]", columns), (String)NODE_COLORS.get((Object)NodeType.OUTPUT));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitDistinctLimit(DistinctLimitNode node, Void context) {
            this.printNode(node, String.format("DistinctLimit[%s]", node.getLimit()), (String)NODE_COLORS.get((Object)NodeType.LIMIT));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitLimit(LimitNode node, Void context) {
            this.printNode(node, String.format("Limit[%s]", node.getCount()), (String)NODE_COLORS.get((Object)NodeType.LIMIT));
            return node.getSource().accept(this, context);
        }

        @Override
        public Void visitTableScan(TableScanNode node, Void context) {
            this.printNode(node, String.format("TableScan[%s]", node.getTable()), String.format("original constraint=%s", node.getOriginalConstraint()), (String)NODE_COLORS.get((Object)NodeType.TABLESCAN));
            return null;
        }

        @Override
        public Void visitValues(ValuesNode node, Void context) {
            this.printNode(node, "Values", (String)NODE_COLORS.get((Object)NodeType.TABLESCAN));
            return null;
        }

        @Override
        public Void visitJoin(JoinNode node, Void context) {
            ArrayList<ComparisonExpression> joinExpressions = new ArrayList<ComparisonExpression>();
            for (JoinNode.EquiJoinClause clause : node.getCriteria()) {
                joinExpressions.add(new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)new QualifiedNameReference(clause.getLeft().toQualifiedName()), (Expression)new QualifiedNameReference(clause.getRight().toQualifiedName())));
            }
            String criteria = Joiner.on((String)" AND ").join(joinExpressions);
            this.printNode(node, node.getType().getJoinLabel(), criteria, (String)NODE_COLORS.get((Object)NodeType.JOIN));
            node.getLeft().accept(this, context);
            node.getRight().accept(this, context);
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Void context) {
            this.printNode(node, "SemiJoin", String.format("%s = %s", node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol()), (String)NODE_COLORS.get((Object)NodeType.JOIN));
            node.getSource().accept(this, context);
            node.getFilteringSource().accept(this, context);
            return null;
        }

        @Override
        public Void visitIndexSource(IndexSourceNode node, Void context) {
            this.printNode(node, String.format("IndexSource[%s]", node.getIndexHandle()), (String)NODE_COLORS.get((Object)NodeType.INDEX_SOURCE));
            return null;
        }

        @Override
        public Void visitIndexJoin(IndexJoinNode node, Void context) {
            ArrayList<ComparisonExpression> joinExpressions = new ArrayList<ComparisonExpression>();
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                joinExpressions.add(new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)new QualifiedNameReference(clause.getProbe().toQualifiedName()), (Expression)new QualifiedNameReference(clause.getIndex().toQualifiedName())));
            }
            String criteria = Joiner.on((String)" AND ").join(joinExpressions);
            String joinLabel = String.format("%sIndexJoin", node.getType().getJoinLabel());
            this.printNode(node, joinLabel, criteria, (String)NODE_COLORS.get((Object)NodeType.JOIN));
            node.getProbeSource().accept(this, context);
            node.getIndexSource().accept(this, context);
            return null;
        }

        private void printNode(PlanNode node, String label, String color) {
            String nodeId = this.idGenerator.getNodeId(node);
            label = NodePrinter.escapeSpecialCharacters(label);
            this.output.append(nodeId).append(String.format("[label=\"{%s}\", style=\"rounded, filled\", shape=record, fillcolor=%s]", label, color)).append(';').append('\n');
        }

        private void printNode(PlanNode node, String label, String details, String color) {
            if (details.length() == 0) {
                this.printNode(node, label, color);
            } else {
                String nodeId = this.idGenerator.getNodeId(node);
                label = NodePrinter.escapeSpecialCharacters(label);
                details = NodePrinter.escapeSpecialCharacters(details);
                this.output.append(nodeId).append(String.format("[label=\"{%s|%s}\", style=\"rounded, filled\", shape=record, fillcolor=%s]", label, details, color)).append(';').append('\n');
            }
        }

        private String getColumns(OutputNode node) {
            Iterator<String> columnNames = node.getColumnNames().iterator();
            String columns = "";
            String columnName = "";
            int nameWidth = 0;
            while (columnNames.hasNext()) {
                columnName = columnNames.next();
                columns = columns + columnName;
                nameWidth += columnName.length();
                if (columnNames.hasNext()) {
                    columns = columns + ", ";
                }
                if (nameWidth < 100) continue;
                columns = columns + "\\n";
                nameWidth = 0;
            }
            return columns;
        }

        private static String escapeSpecialCharacters(String label) {
            return label.replace("<", "\\<").replace(">", "\\>").replace("\"", "\\\"");
        }
    }

    static enum NodeType {
        EXCHANGE,
        AGGREGATE,
        FILTER,
        PROJECT,
        TOPN,
        OUTPUT,
        LIMIT,
        TABLESCAN,
        VALUES,
        JOIN,
        SINK,
        WINDOW,
        UNION,
        SORT,
        MARK_DISTINCT,
        MATERIALIZE_SAMPLE,
        INDEX_SOURCE;

    }
}

