/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.SqlType;
import io.airlift.slice.Slice;
import java.nio.charset.StandardCharsets;

public final class VarcharOperators {
    private VarcharOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean equal(@SqlType(value=VarcharType.class) Slice left, @SqlType(value=VarcharType.class) Slice right) {
        return left.equals((Object)right);
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean notEqual(@SqlType(value=VarcharType.class) Slice left, @SqlType(value=VarcharType.class) Slice right) {
        return !left.equals((Object)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value=BooleanType.class)
    public static boolean lessThan(@SqlType(value=VarcharType.class) Slice left, @SqlType(value=VarcharType.class) Slice right) {
        return left.compareTo(right) < 0;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean lessThanOrEqual(@SqlType(value=VarcharType.class) Slice left, @SqlType(value=VarcharType.class) Slice right) {
        return left.compareTo(right) <= 0;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value=BooleanType.class)
    public static boolean greaterThan(@SqlType(value=VarcharType.class) Slice left, @SqlType(value=VarcharType.class) Slice right) {
        return left.compareTo(right) > 0;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean greaterThanOrEqual(@SqlType(value=VarcharType.class) Slice left, @SqlType(value=VarcharType.class) Slice right) {
        return left.compareTo(right) >= 0;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value=BooleanType.class)
    public static boolean between(@SqlType(value=VarcharType.class) Slice value, @SqlType(value=VarcharType.class) Slice min, @SqlType(value=VarcharType.class) Slice max) {
        return min.compareTo(value) <= 0 && value.compareTo(max) <= 0;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=BooleanType.class)
    public static boolean castToBoolean(@SqlType(value=VarcharType.class) Slice value) {
        if (value.length() == 1) {
            byte character = VarcharOperators.toUpperCase(value.getByte(0));
            if (character == 84 || character == 49) {
                return true;
            }
            if (character == 70 || character == 48) {
                return false;
            }
        }
        if (value.length() == 4 && VarcharOperators.toUpperCase(value.getByte(0)) == 84 && VarcharOperators.toUpperCase(value.getByte(1)) == 82 && VarcharOperators.toUpperCase(value.getByte(2)) == 85 && VarcharOperators.toUpperCase(value.getByte(3)) == 69) {
            return true;
        }
        if (value.length() == 5 && VarcharOperators.toUpperCase(value.getByte(0)) == 70 && VarcharOperators.toUpperCase(value.getByte(1)) == 65 && VarcharOperators.toUpperCase(value.getByte(2)) == 76 && VarcharOperators.toUpperCase(value.getByte(3)) == 83 && VarcharOperators.toUpperCase(value.getByte(4)) == 69) {
            return false;
        }
        throw new PrestoException(StandardErrorCode.INVALID_CAST_ARGUMENT.toErrorCode(), String.format("Cannot cast '%s' to BOOLEAN", value.toString(StandardCharsets.UTF_8)));
    }

    private static byte toUpperCase(byte b) {
        return VarcharOperators.isLowerCase(b) ? (byte)(b - 32) : b;
    }

    private static boolean isLowerCase(byte b) {
        return b >= 97 && b <= 122;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=DoubleType.class)
    public static double castToDouble(@SqlType(value=VarcharType.class) Slice slice) {
        try {
            return Double.parseDouble(slice.toString(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new PrestoException(StandardErrorCode.INVALID_CAST_ARGUMENT.toErrorCode(), String.format("Can not cast '%s' to DOUBLE", slice.toString(StandardCharsets.UTF_8)));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=BigintType.class)
    public static long castToBigint(@SqlType(value=VarcharType.class) Slice slice) {
        try {
            return Long.parseLong(slice.toString(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new PrestoException(StandardErrorCode.INVALID_CAST_ARGUMENT.toErrorCode(), String.format("Can not cast '%s' to BIGINT", slice.toString(StandardCharsets.UTF_8)));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=VarbinaryType.class)
    public static Slice castToBinary(@SqlType(value=VarcharType.class) Slice slice) {
        return slice;
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    public static int hashCode(@SqlType(value=VarcharType.class) Slice value) {
        return value.hashCode();
    }
}

