/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.DateTimeOperators;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.util.DateTimeUtils;
import com.facebook.presto.util.DateTimeZoneIndex;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.joda.time.chrono.ISOChronology;

public final class TimestampWithTimeZoneOperators {
    private TimestampWithTimeZoneOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean equal(@SqlType(value=TimestampWithTimeZoneType.class) long left, @SqlType(value=TimestampWithTimeZoneType.class) long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) == DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean notEqual(@SqlType(value=TimestampWithTimeZoneType.class) long left, @SqlType(value=TimestampWithTimeZoneType.class) long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) != DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value=BooleanType.class)
    public static boolean lessThan(@SqlType(value=TimestampWithTimeZoneType.class) long left, @SqlType(value=TimestampWithTimeZoneType.class) long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) < DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean lessThanOrEqual(@SqlType(value=TimestampWithTimeZoneType.class) long left, @SqlType(value=TimestampWithTimeZoneType.class) long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) <= DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value=BooleanType.class)
    public static boolean greaterThan(@SqlType(value=TimestampWithTimeZoneType.class) long left, @SqlType(value=TimestampWithTimeZoneType.class) long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) > DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean greaterThanOrEqual(@SqlType(value=TimestampWithTimeZoneType.class) long left, @SqlType(value=TimestampWithTimeZoneType.class) long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) >= DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value=BooleanType.class)
    public static boolean between(@SqlType(value=TimestampWithTimeZoneType.class) long value, @SqlType(value=TimestampWithTimeZoneType.class) long min, @SqlType(value=TimestampWithTimeZoneType.class) long max) {
        return DateTimeEncoding.unpackMillisUtc((long)min) <= DateTimeEncoding.unpackMillisUtc((long)value) && DateTimeEncoding.unpackMillisUtc((long)value) <= DateTimeEncoding.unpackMillisUtc((long)max);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=DateType.class)
    public static long castToDate(@SqlType(value=TimestampWithTimeZoneType.class) long value) {
        ISOChronology chronology = DateTimeZoneIndex.unpackChronology(value);
        long date = chronology.dayOfYear().roundFloor(DateTimeEncoding.unpackMillisUtc((long)value));
        return date + (long)chronology.getZone().getOffset(date);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=TimeType.class)
    public static long castToTime(@SqlType(value=TimestampWithTimeZoneType.class) long value) {
        return DateTimeOperators.modulo24Hour(DateTimeZoneIndex.unpackChronology(value), DateTimeEncoding.unpackMillisUtc((long)value));
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=TimeWithTimeZoneType.class)
    public static long castToTimeWithTimeZone(@SqlType(value=TimestampWithTimeZoneType.class) long value) {
        int millis = DateTimeOperators.modulo24Hour(DateTimeZoneIndex.unpackChronology(value), DateTimeEncoding.unpackMillisUtc((long)value));
        return DateTimeEncoding.packDateTimeWithZone((long)millis, (TimeZoneKey)DateTimeEncoding.unpackZoneKey((long)value));
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=TimestampType.class)
    public static long castToTimestamp(@SqlType(value=TimestampWithTimeZoneType.class) long value) {
        return DateTimeEncoding.unpackMillisUtc((long)value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=VarcharType.class)
    public static Slice castToSlice(@SqlType(value=TimestampWithTimeZoneType.class) long value) {
        return Slices.copiedBuffer((String)DateTimeUtils.printTimestampWithTimeZone(value), (Charset)StandardCharsets.UTF_8);
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    public static int hashCode(@SqlType(value=TimestampWithTimeZoneType.class) long value) {
        long millis = DateTimeEncoding.unpackMillisUtc((long)value);
        return (int)(millis ^ millis >>> 32);
    }
}

