/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.DateTimeOperators;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.util.DateTimeUtils;
import com.facebook.presto.util.DateTimeZoneIndex;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.joda.time.chrono.ISOChronology;

public final class TimestampOperators {
    private TimestampOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean equal(@SqlType(value=TimestampType.class) long left, @SqlType(value=TimestampType.class) long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean notEqual(@SqlType(value=TimestampType.class) long left, @SqlType(value=TimestampType.class) long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value=BooleanType.class)
    public static boolean lessThan(@SqlType(value=TimestampType.class) long left, @SqlType(value=TimestampType.class) long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean lessThanOrEqual(@SqlType(value=TimestampType.class) long left, @SqlType(value=TimestampType.class) long right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value=BooleanType.class)
    public static boolean greaterThan(@SqlType(value=TimestampType.class) long left, @SqlType(value=TimestampType.class) long right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean greaterThanOrEqual(@SqlType(value=TimestampType.class) long left, @SqlType(value=TimestampType.class) long right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value=BooleanType.class)
    public static boolean between(@SqlType(value=TimestampType.class) long value, @SqlType(value=TimestampType.class) long min, @SqlType(value=TimestampType.class) long max) {
        return min <= value && value <= max;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=DateType.class)
    public static long castToDate(ConnectorSession session, @SqlType(value=TimestampType.class) long value) {
        ISOChronology chronology = DateTimeZoneIndex.getChronology(session.getTimeZoneKey());
        long date = chronology.dayOfYear().roundFloor(value);
        return date + (long)chronology.getZone().getOffset(date);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=TimeType.class)
    public static long castToTime(ConnectorSession session, @SqlType(value=TimestampType.class) long value) {
        return DateTimeOperators.modulo24Hour(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=TimeWithTimeZoneType.class)
    public static long castToTimeWithTimeZone(ConnectorSession session, @SqlType(value=TimestampType.class) long value) {
        int timeMillis = DateTimeOperators.modulo24Hour(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), value);
        return DateTimeEncoding.packDateTimeWithZone((long)timeMillis, (TimeZoneKey)session.getTimeZoneKey());
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=TimestampWithTimeZoneType.class)
    public static long castToTimestampWithTimeZone(ConnectorSession session, @SqlType(value=TimestampType.class) long value) {
        return DateTimeEncoding.packDateTimeWithZone((long)value, (TimeZoneKey)session.getTimeZoneKey());
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=VarcharType.class)
    public static Slice castToSlice(ConnectorSession session, @SqlType(value=TimestampType.class) long value) {
        return Slices.copiedBuffer((String)DateTimeUtils.printTimestampWithoutTimeZone(session.getTimeZoneKey(), value), (Charset)StandardCharsets.UTF_8);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=TimestampType.class)
    public static long castFromSlice(ConnectorSession session, @SqlType(value=VarcharType.class) Slice value) {
        try {
            return DateTimeUtils.parseTimestampWithoutTimeZone(session.getTimeZoneKey(), value.toStringUtf8());
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException(StandardErrorCode.INVALID_CAST_ARGUMENT.toErrorCode(), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    public static int hashCode(@SqlType(value=TimestampType.class) long value) {
        return (int)(value ^ value >>> 32);
    }
}

