/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.util.DateTimeUtils;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class TimeWithTimeZoneOperators {
    private TimeWithTimeZoneOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean equal(@SqlType(value=TimeWithTimeZoneType.class) long left, @SqlType(value=TimeWithTimeZoneType.class) long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) == DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean notEqual(@SqlType(value=TimeWithTimeZoneType.class) long left, @SqlType(value=TimeWithTimeZoneType.class) long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) != DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value=BooleanType.class)
    public static boolean lessThan(@SqlType(value=TimeWithTimeZoneType.class) long left, @SqlType(value=TimeWithTimeZoneType.class) long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) < DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean lessThanOrEqual(@SqlType(value=TimeWithTimeZoneType.class) long left, @SqlType(value=TimeWithTimeZoneType.class) long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) <= DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value=BooleanType.class)
    public static boolean greaterThan(@SqlType(value=TimeWithTimeZoneType.class) long left, @SqlType(value=TimeWithTimeZoneType.class) long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) > DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean greaterThanOrEqual(@SqlType(value=TimeWithTimeZoneType.class) long left, @SqlType(value=TimeWithTimeZoneType.class) long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) >= DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value=BooleanType.class)
    public static boolean between(@SqlType(value=TimeWithTimeZoneType.class) long value, @SqlType(value=TimeWithTimeZoneType.class) long min, @SqlType(value=TimeWithTimeZoneType.class) long max) {
        return DateTimeEncoding.unpackMillisUtc((long)min) <= DateTimeEncoding.unpackMillisUtc((long)value) && DateTimeEncoding.unpackMillisUtc((long)value) <= DateTimeEncoding.unpackMillisUtc((long)max);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=TimeType.class)
    public static long castToTime(ConnectorSession session, @SqlType(value=TimeWithTimeZoneType.class) long value) {
        return DateTimeEncoding.unpackMillisUtc((long)value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=TimestampType.class)
    public static long castToTimestamp(@SqlType(value=TimeWithTimeZoneType.class) long value) {
        return DateTimeEncoding.unpackMillisUtc((long)value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=TimestampWithTimeZoneType.class)
    public static long castToTimestampWithTimeZone(@SqlType(value=TimeWithTimeZoneType.class) long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=VarcharType.class)
    public static Slice castToSlice(@SqlType(value=TimeWithTimeZoneType.class) long value) {
        return Slices.copiedBuffer((String)DateTimeUtils.printTimeWithTimeZone(value), (Charset)StandardCharsets.UTF_8);
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    public static int hashCode(@SqlType(value=TimeWithTimeZoneType.class) long value) {
        long millis = DateTimeEncoding.unpackMillisUtc((long)value);
        return (int)(millis ^ millis >>> 32);
    }
}

