/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntervalYearMonthType;
import com.facebook.presto.spi.type.SqlIntervalYearMonth;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.SqlType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public final class IntervalYearMonthOperators {
    private IntervalYearMonthOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=IntervalYearMonthType.class)
    public static long add(@SqlType(value=IntervalYearMonthType.class) long left, @SqlType(value=IntervalYearMonthType.class) long right) {
        return left + right;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value=IntervalYearMonthType.class)
    public static long subtract(@SqlType(value=IntervalYearMonthType.class) long left, @SqlType(value=IntervalYearMonthType.class) long right) {
        return left - right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value=IntervalYearMonthType.class)
    public static long multiplyByBigint(@SqlType(value=IntervalYearMonthType.class) long left, @SqlType(value=BigintType.class) long right) {
        return left * right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value=IntervalYearMonthType.class)
    public static long multiplyByDouble(@SqlType(value=IntervalYearMonthType.class) long left, @SqlType(value=DoubleType.class) double right) {
        return (long)((double)left * right);
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value=IntervalYearMonthType.class)
    public static long bigintMultiply(@SqlType(value=BigintType.class) long left, @SqlType(value=IntervalYearMonthType.class) long right) {
        return left * right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value=IntervalYearMonthType.class)
    public static long doubleMultiply(@SqlType(value=DoubleType.class) double left, @SqlType(value=IntervalYearMonthType.class) long right) {
        return (long)(left * (double)right);
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value=IntervalYearMonthType.class)
    public static long divideByDouble(@SqlType(value=IntervalYearMonthType.class) long left, @SqlType(value=DoubleType.class) double right) {
        return (long)((double)left / right);
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value=IntervalYearMonthType.class)
    public static long negate(@SqlType(value=IntervalYearMonthType.class) long value) {
        return -value;
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean equal(@SqlType(value=IntervalYearMonthType.class) long left, @SqlType(value=IntervalYearMonthType.class) long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean notEqual(@SqlType(value=IntervalYearMonthType.class) long left, @SqlType(value=IntervalYearMonthType.class) long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value=BooleanType.class)
    public static boolean lessThan(@SqlType(value=IntervalYearMonthType.class) long left, @SqlType(value=IntervalYearMonthType.class) long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean lessThanOrEqual(@SqlType(value=IntervalYearMonthType.class) long left, @SqlType(value=IntervalYearMonthType.class) long right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value=BooleanType.class)
    public static boolean greaterThan(@SqlType(value=IntervalYearMonthType.class) long left, @SqlType(value=IntervalYearMonthType.class) long right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean greaterThanOrEqual(@SqlType(value=IntervalYearMonthType.class) long left, @SqlType(value=IntervalYearMonthType.class) long right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value=BooleanType.class)
    public static boolean between(@SqlType(value=IntervalYearMonthType.class) long value, @SqlType(value=IntervalYearMonthType.class) long min, @SqlType(value=IntervalYearMonthType.class) long max) {
        return min <= value && value <= max;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=VarcharType.class)
    public static Slice castToSlice(@SqlType(value=IntervalYearMonthType.class) long value) {
        return Slices.utf8Slice((String)SqlIntervalYearMonth.formatMonths((long)value));
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    public static int hashCode(@SqlType(value=IntervalYearMonthType.class) long value) {
        return (int)(value ^ value >>> 32);
    }
}

