/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntervalDayTimeType;
import com.facebook.presto.spi.type.SqlIntervalDayTime;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.SqlType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class IntervalDayTimeOperators {
    private IntervalDayTimeOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=IntervalDayTimeType.class)
    public static long add(@SqlType(value=IntervalDayTimeType.class) long left, @SqlType(value=IntervalDayTimeType.class) long right) {
        return left + right;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value=IntervalDayTimeType.class)
    public static long subtract(@SqlType(value=IntervalDayTimeType.class) long left, @SqlType(value=IntervalDayTimeType.class) long right) {
        return left - right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value=IntervalDayTimeType.class)
    public static long multiplyByBigint(@SqlType(value=IntervalDayTimeType.class) long left, @SqlType(value=BigintType.class) long right) {
        return left * right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value=IntervalDayTimeType.class)
    public static long multiplyByDouble(@SqlType(value=IntervalDayTimeType.class) long left, @SqlType(value=DoubleType.class) double right) {
        return (long)((double)left * right);
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value=IntervalDayTimeType.class)
    public static long bigintMultiply(@SqlType(value=BigintType.class) long left, @SqlType(value=IntervalDayTimeType.class) long right) {
        return left * right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value=IntervalDayTimeType.class)
    public static long doubleMultiply(@SqlType(value=DoubleType.class) double left, @SqlType(value=IntervalDayTimeType.class) long right) {
        return (long)(left * (double)right);
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value=IntervalDayTimeType.class)
    public static long divideByDouble(@SqlType(value=IntervalDayTimeType.class) long left, @SqlType(value=DoubleType.class) double right) {
        return (long)((double)left / right);
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value=IntervalDayTimeType.class)
    public static long negate(@SqlType(value=IntervalDayTimeType.class) long value) {
        return -value;
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean equal(@SqlType(value=IntervalDayTimeType.class) long left, @SqlType(value=IntervalDayTimeType.class) long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean notEqual(@SqlType(value=IntervalDayTimeType.class) long left, @SqlType(value=IntervalDayTimeType.class) long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value=BooleanType.class)
    public static boolean lessThan(@SqlType(value=IntervalDayTimeType.class) long left, @SqlType(value=IntervalDayTimeType.class) long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean lessThanOrEqual(@SqlType(value=IntervalDayTimeType.class) long left, @SqlType(value=IntervalDayTimeType.class) long right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value=BooleanType.class)
    public static boolean greaterThan(@SqlType(value=IntervalDayTimeType.class) long left, @SqlType(value=IntervalDayTimeType.class) long right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean greaterThanOrEqual(@SqlType(value=IntervalDayTimeType.class) long left, @SqlType(value=IntervalDayTimeType.class) long right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value=BooleanType.class)
    public static boolean between(@SqlType(value=IntervalDayTimeType.class) long value, @SqlType(value=IntervalDayTimeType.class) long min, @SqlType(value=IntervalDayTimeType.class) long max) {
        return min <= value && value <= max;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=VarcharType.class)
    public static Slice castToSlice(@SqlType(value=IntervalDayTimeType.class) long value) {
        return Slices.copiedBuffer((String)SqlIntervalDayTime.formatMillis((long)value), (Charset)StandardCharsets.UTF_8);
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    public static int hashCode(@SqlType(value=IntervalDayTimeType.class) long value) {
        return (int)(value ^ value >>> 32);
    }
}

