/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.IntervalDayTimeType;
import com.facebook.presto.spi.type.IntervalYearMonthType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.util.DateTimeZoneIndex;
import org.joda.time.DateTimeField;
import org.joda.time.chrono.ISOChronology;

public final class DateTimeOperators {
    private static final DateTimeField MILLIS_OF_DAY = ISOChronology.getInstanceUTC().millisOfDay();
    private static final DateTimeField MONTH_OF_YEAR_UTC = ISOChronology.getInstanceUTC().monthOfYear();

    private DateTimeOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=DateType.class)
    public static long datePlusIntervalDayToSecond(@SqlType(value=DateType.class) long left, @SqlType(value=IntervalDayTimeType.class) long right) {
        if (MILLIS_OF_DAY.get(right) != 0) {
            throw new IllegalArgumentException("Can not add hour, minutes or seconds to a Date");
        }
        return left + right;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=DateType.class)
    public static long intervalDayToSecondPlusDate(@SqlType(value=IntervalDayTimeType.class) long left, @SqlType(value=DateType.class) long right) {
        if (MILLIS_OF_DAY.get(left) != 0) {
            throw new IllegalArgumentException("Can not add hour, minutes or seconds to a Date");
        }
        return left + right;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=TimeType.class)
    public static long timePlusIntervalDayToSecond(ConnectorSession session, @SqlType(value=TimeType.class) long left, @SqlType(value=IntervalDayTimeType.class) long right) {
        return DateTimeOperators.modulo24Hour(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), left + right);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=TimeType.class)
    public static long intervalDayToSecondPlusTime(ConnectorSession session, @SqlType(value=IntervalDayTimeType.class) long left, @SqlType(value=TimeType.class) long right) {
        return DateTimeOperators.modulo24Hour(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), left + right);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=TimeWithTimeZoneType.class)
    public static long timeWithTimeZonePlusIntervalDayToSecond(@SqlType(value=TimeWithTimeZoneType.class) long left, @SqlType(value=IntervalDayTimeType.class) long right) {
        return DateTimeEncoding.updateMillisUtc((long)DateTimeOperators.modulo24Hour(DateTimeZoneIndex.unpackChronology(left), DateTimeEncoding.unpackMillisUtc((long)left) + right), (long)left);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=TimeWithTimeZoneType.class)
    public static long intervalDayToSecondPlusTimeWithTimeZone(@SqlType(value=IntervalDayTimeType.class) long left, @SqlType(value=TimeWithTimeZoneType.class) long right) {
        return DateTimeEncoding.updateMillisUtc((long)DateTimeOperators.modulo24Hour(DateTimeZoneIndex.unpackChronology(right), left + DateTimeEncoding.unpackMillisUtc((long)right)), (long)right);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=TimestampType.class)
    public static long timestampPlusIntervalDayToSecond(@SqlType(value=TimestampType.class) long left, @SqlType(value=IntervalDayTimeType.class) long right) {
        return left + right;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=TimestampType.class)
    public static long intervalDayToSecondPlusTimestamp(@SqlType(value=IntervalDayTimeType.class) long left, @SqlType(value=TimestampType.class) long right) {
        return left + right;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=TimestampWithTimeZoneType.class)
    public static long timestampWithTimeZonePlusIntervalDayToSecond(@SqlType(value=TimestampWithTimeZoneType.class) long left, @SqlType(value=IntervalDayTimeType.class) long right) {
        return DateTimeEncoding.updateMillisUtc((long)(DateTimeEncoding.unpackMillisUtc((long)left) + right), (long)left);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=TimestampWithTimeZoneType.class)
    public static long intervalDayToSecondPlusTimestampWithTimeZone(@SqlType(value=IntervalDayTimeType.class) long left, @SqlType(value=TimestampWithTimeZoneType.class) long right) {
        return DateTimeEncoding.updateMillisUtc((long)(left + DateTimeEncoding.unpackMillisUtc((long)right)), (long)right);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=DateType.class)
    public static long datePlusIntervalYearToMonth(@SqlType(value=DateType.class) long left, @SqlType(value=IntervalYearMonthType.class) long right) {
        return MONTH_OF_YEAR_UTC.add(left, right);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=DateType.class)
    public static long intervalYearToMonthPlusDate(@SqlType(value=IntervalYearMonthType.class) long left, @SqlType(value=DateType.class) long right) {
        return MONTH_OF_YEAR_UTC.add(right, left);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=TimeType.class)
    public static long timePlusIntervalYearToMonth(@SqlType(value=TimeType.class) long left, @SqlType(value=IntervalYearMonthType.class) long right) {
        return left;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=TimeType.class)
    public static long intervalYearToMonthPlusTime(@SqlType(value=IntervalYearMonthType.class) long left, @SqlType(value=TimeType.class) long right) {
        return right;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=TimeWithTimeZoneType.class)
    public static long timeWithTimeZonePlusIntervalYearToMonth(@SqlType(value=TimeWithTimeZoneType.class) long left, @SqlType(value=IntervalYearMonthType.class) long right) {
        return left;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=TimeWithTimeZoneType.class)
    public static long intervalYearToMonthPlusTimeWithTimeZone(@SqlType(value=IntervalYearMonthType.class) long left, @SqlType(value=TimeWithTimeZoneType.class) long right) {
        return right;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=TimestampType.class)
    public static long timestampPlusIntervalYearToMonth(ConnectorSession session, @SqlType(value=TimestampType.class) long left, @SqlType(value=IntervalYearMonthType.class) long right) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).monthOfYear().add(left, right);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=TimestampType.class)
    public static long intervalYearToMonthPlusTimestamp(ConnectorSession session, @SqlType(value=IntervalYearMonthType.class) long left, @SqlType(value=TimestampType.class) long right) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).monthOfYear().add(right, left);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=TimestampWithTimeZoneType.class)
    public static long timestampWithTimeZonePlusIntervalYearToMonth(@SqlType(value=TimestampWithTimeZoneType.class) long left, @SqlType(value=IntervalYearMonthType.class) long right) {
        return DateTimeEncoding.updateMillisUtc((long)DateTimeZoneIndex.unpackChronology(left).monthOfYear().add(DateTimeEncoding.unpackMillisUtc((long)left), right), (long)left);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=TimestampWithTimeZoneType.class)
    public static long intervalYearToMonthPlusTimestampWithTimeZone(@SqlType(value=IntervalYearMonthType.class) long left, @SqlType(value=TimestampWithTimeZoneType.class) long right) {
        return DateTimeEncoding.updateMillisUtc((long)DateTimeZoneIndex.unpackChronology(right).monthOfYear().add(DateTimeEncoding.unpackMillisUtc((long)right), left), (long)right);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value=DateType.class)
    public static long dateMinusIntervalDayToSecond(@SqlType(value=DateType.class) long left, @SqlType(value=IntervalDayTimeType.class) long right) {
        if (MILLIS_OF_DAY.get(right) != 0) {
            throw new IllegalArgumentException("Can not subtract hour, minutes or seconds from a Date");
        }
        return left - right;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value=TimeType.class)
    public static long timeMinusIntervalDayToSecond(ConnectorSession session, @SqlType(value=TimeType.class) long left, @SqlType(value=IntervalDayTimeType.class) long right) {
        return DateTimeOperators.modulo24Hour(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), left - right);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value=TimeWithTimeZoneType.class)
    public static long timeWithTimeZoneMinusIntervalDayToSecond(@SqlType(value=TimeWithTimeZoneType.class) long left, @SqlType(value=IntervalDayTimeType.class) long right) {
        return DateTimeEncoding.updateMillisUtc((long)DateTimeOperators.modulo24Hour(DateTimeZoneIndex.unpackChronology(left), DateTimeEncoding.unpackMillisUtc((long)left) - right), (long)left);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value=TimestampType.class)
    public static long timestampMinusIntervalDayToSecond(@SqlType(value=TimestampType.class) long left, @SqlType(value=IntervalDayTimeType.class) long right) {
        return left - right;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value=TimestampWithTimeZoneType.class)
    public static long timestampWithTimeZoneMinusIntervalDayToSecond(@SqlType(value=TimestampWithTimeZoneType.class) long left, @SqlType(value=IntervalDayTimeType.class) long right) {
        return DateTimeEncoding.updateMillisUtc((long)(DateTimeEncoding.unpackMillisUtc((long)left) - right), (long)left);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value=DateType.class)
    public static long dateMinusIntervalYearToMonth(ConnectorSession session, @SqlType(value=DateType.class) long left, @SqlType(value=IntervalYearMonthType.class) long right) {
        return MONTH_OF_YEAR_UTC.add(left, -right);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value=TimeType.class)
    public static long timeMinusIntervalYearToMonth(@SqlType(value=TimeType.class) long left, @SqlType(value=IntervalYearMonthType.class) long right) {
        return left;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value=TimeWithTimeZoneType.class)
    public static long timeWithTimeZoneMinusIntervalYearToMonth(@SqlType(value=TimeWithTimeZoneType.class) long left, @SqlType(value=IntervalYearMonthType.class) long right) {
        return left;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value=TimestampType.class)
    public static long timestampMinusIntervalYearToMonth(ConnectorSession session, @SqlType(value=TimestampType.class) long left, @SqlType(value=IntervalYearMonthType.class) long right) {
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).monthOfYear().add(left, -right);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value=TimestampWithTimeZoneType.class)
    public static long timestampWithTimeZoneMinusIntervalYearToMonth(@SqlType(value=TimestampWithTimeZoneType.class) long left, @SqlType(value=IntervalYearMonthType.class) long right) {
        long dateTimeWithTimeZone = DateTimeZoneIndex.unpackChronology(left).monthOfYear().add(DateTimeEncoding.unpackMillisUtc((long)left), -right);
        return DateTimeEncoding.updateMillisUtc((long)dateTimeWithTimeZone, (long)left);
    }

    public static int modulo24Hour(ISOChronology chronology, long millis) {
        return chronology.millisOfDay().get(millis) - chronology.getZone().getOffset(millis);
    }
}

