/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.SqlType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class BooleanOperators {
    private static final Slice TRUE = Slices.copiedBuffer((String)"true", (Charset)StandardCharsets.US_ASCII);
    private static final Slice FALSE = Slices.copiedBuffer((String)"false", (Charset)StandardCharsets.US_ASCII);

    private BooleanOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean equal(@SqlType(value=BooleanType.class) boolean left, @SqlType(value=BooleanType.class) boolean right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean notEqual(@SqlType(value=BooleanType.class) boolean left, @SqlType(value=BooleanType.class) boolean right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value=BooleanType.class)
    public static boolean lessThan(@SqlType(value=BooleanType.class) boolean left, @SqlType(value=BooleanType.class) boolean right) {
        return !left && right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean lessThanOrEqual(@SqlType(value=BooleanType.class) boolean left, @SqlType(value=BooleanType.class) boolean right) {
        return !left || right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value=BooleanType.class)
    public static boolean greaterThan(@SqlType(value=BooleanType.class) boolean left, @SqlType(value=BooleanType.class) boolean right) {
        return left && !right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean greaterThanOrEqual(@SqlType(value=BooleanType.class) boolean left, @SqlType(value=BooleanType.class) boolean right) {
        return left || !right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value=BooleanType.class)
    public static boolean between(@SqlType(value=BooleanType.class) boolean value, @SqlType(value=BooleanType.class) boolean min, @SqlType(value=BooleanType.class) boolean max) {
        return value && max || !value && !min;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=DoubleType.class)
    public static double castToDouble(@SqlType(value=BooleanType.class) boolean value) {
        return value ? 1.0 : 0.0;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=BigintType.class)
    public static long castToBigint(@SqlType(value=BooleanType.class) boolean value) {
        return value ? 1L : 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=VarcharType.class)
    public static Slice castToVarchar(@SqlType(value=BooleanType.class) boolean value) {
        return value ? TRUE : FALSE;
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    public static int hashCode(@SqlType(value=BooleanType.class) boolean value) {
        return value ? 1231 : 1237;
    }
}

