/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.SqlType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class BigintOperators {
    private BigintOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value=BigintType.class)
    public static long add(@SqlType(value=BigintType.class) long left, @SqlType(value=BigintType.class) long right) {
        return left + right;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value=BigintType.class)
    public static long subtract(@SqlType(value=BigintType.class) long left, @SqlType(value=BigintType.class) long right) {
        return left - right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value=BigintType.class)
    public static long multiply(@SqlType(value=BigintType.class) long left, @SqlType(value=BigintType.class) long right) {
        return left * right;
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value=BigintType.class)
    public static long divide(@SqlType(value=BigintType.class) long left, @SqlType(value=BigintType.class) long right) {
        try {
            return left / right;
        }
        catch (ArithmeticException e) {
            throw new PrestoException(StandardErrorCode.DIVISION_BY_ZERO.toErrorCode(), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.MODULUS)
    @SqlType(value=BigintType.class)
    public static long modulus(@SqlType(value=BigintType.class) long left, @SqlType(value=BigintType.class) long right) {
        try {
            return left % right;
        }
        catch (ArithmeticException e) {
            throw new PrestoException(StandardErrorCode.DIVISION_BY_ZERO.toErrorCode(), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value=BigintType.class)
    public static long negate(@SqlType(value=BigintType.class) long value) {
        return -value;
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean equal(@SqlType(value=BigintType.class) long left, @SqlType(value=BigintType.class) long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean notEqual(@SqlType(value=BigintType.class) long left, @SqlType(value=BigintType.class) long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value=BooleanType.class)
    public static boolean lessThan(@SqlType(value=BigintType.class) long left, @SqlType(value=BigintType.class) long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean lessThanOrEqual(@SqlType(value=BigintType.class) long left, @SqlType(value=BigintType.class) long right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value=BooleanType.class)
    public static boolean greaterThan(@SqlType(value=BigintType.class) long left, @SqlType(value=BigintType.class) long right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value=BooleanType.class)
    public static boolean greaterThanOrEqual(@SqlType(value=BigintType.class) long left, @SqlType(value=BigintType.class) long right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value=BooleanType.class)
    public static boolean between(@SqlType(value=BigintType.class) long value, @SqlType(value=BigintType.class) long min, @SqlType(value=BigintType.class) long max) {
        return min <= value && value <= max;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=BooleanType.class)
    public static boolean castToBoolean(@SqlType(value=BigintType.class) long value) {
        return value != 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=DoubleType.class)
    public static double castToDouble(@SqlType(value=BigintType.class) long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value=VarcharType.class)
    public static Slice castToVarchar(@SqlType(value=BigintType.class) long value) {
        return Slices.copiedBuffer((String)String.valueOf(value), (Charset)StandardCharsets.UTF_8);
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    public static int hashCode(@SqlType(value=BigintType.class) long value) {
        return (int)(value ^ value >>> 32);
    }
}

