/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.metadata.OutputTableHandle;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TableWriterNode
extends PlanNode {
    private final PlanNode source;
    private final OutputTableHandle target;
    private final List<Symbol> outputs;
    private final List<Symbol> columns;
    private final List<String> columnNames;
    private final Optional<Symbol> sampleWeightSymbol;
    private final String catalog;
    private final TableMetadata tableMetadata;
    private final boolean sampleWeightSupported;

    @JsonCreator
    public TableWriterNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="target") OutputTableHandle target, @JsonProperty(value="columns") List<Symbol> columns, @JsonProperty(value="columnNames") List<String> columnNames, @JsonProperty(value="outputs") List<Symbol> outputs, @JsonProperty(value="sampleWeightSymbol") Optional<Symbol> sampleWeightSymbol) {
        this(id, source, target, columns, columnNames, outputs, sampleWeightSymbol, null, null, false);
    }

    public TableWriterNode(PlanNodeId id, PlanNode source, OutputTableHandle target, List<Symbol> columns, List<String> columnNames, List<Symbol> outputs, Optional<Symbol> sampleWeightSymbol, String catalog, TableMetadata tableMetadata, boolean sampleWeightSupported) {
        super(id);
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        Preconditions.checkNotNull(columnNames, (Object)"columnNames is null");
        Preconditions.checkArgument((columns.size() == columnNames.size() ? 1 : 0) != 0, (Object)"columns and columnNames sizes don't match");
        Preconditions.checkArgument((boolean)(target == null ^ (catalog == null && tableMetadata == null)), (Object)"exactly one of target or (catalog, tableMetadata) must be set");
        this.source = (PlanNode)Preconditions.checkNotNull((Object)source, (Object)"source is null");
        this.target = target;
        this.columns = ImmutableList.copyOf(columns);
        this.columnNames = ImmutableList.copyOf(columnNames);
        this.outputs = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(outputs, (Object)"outputs is null")));
        this.sampleWeightSymbol = (Optional)Preconditions.checkNotNull(sampleWeightSymbol, (Object)"sampleWeightSymbol is null");
        this.catalog = catalog;
        this.tableMetadata = tableMetadata;
        this.sampleWeightSupported = sampleWeightSupported;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public TableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public boolean isSampleWeightSupported() {
        return this.sampleWeightSupported;
    }

    @JsonProperty
    public Optional<Symbol> getSampleWeightSymbol() {
        return this.sampleWeightSymbol;
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public OutputTableHandle getTarget() {
        return this.target;
    }

    @JsonProperty
    public List<Symbol> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    @JsonProperty(value="outputs")
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitTableWriter(this, context);
    }
}

