/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MaterializeSampleNode
extends PlanNode {
    private final PlanNode source;
    private final Symbol sampleWeightSymbol;

    @JsonCreator
    public MaterializeSampleNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="sampleWeightSymbol") Symbol sampleWeightSymbol) {
        super(id);
        this.source = (PlanNode)Preconditions.checkNotNull((Object)source, (Object)"source is null");
        this.sampleWeightSymbol = (Symbol)Preconditions.checkNotNull((Object)sampleWeightSymbol, (Object)"sampleWeightSymbol is null");
        Preconditions.checkArgument((boolean)source.getOutputSymbols().contains(sampleWeightSymbol), (Object)"source does not output sample weight");
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return FluentIterable.from(this.source.getOutputSymbols()).filter(Predicates.not((Predicate)Predicates.equalTo((Object)this.sampleWeightSymbol))).toList();
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public Symbol getSampleWeightSymbol() {
        return this.sampleWeightSymbol;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitMaterializeSample(this, context);
    }
}

